/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.tags;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.apply.ChunkCssApplier;
import com.itextpdf.tool.xml.svg.AbstractGraphicProcessor;
import com.itextpdf.tool.xml.svg.graphic.Text;
import com.itextpdf.tool.xml.svg.graphic.TextGroup;
import com.itextpdf.tool.xml.svg.graphic.TextPathGroup;
import com.itextpdf.tool.xml.svg.tags.TagUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextTag
extends AbstractGraphicProcessor {
    static final String X = "x";
    static final String Y = "y";
    static final String DX = "dx";
    static final String DY = "dy";

    @Override
    public List<Element> start(WorkerContext ctx, Tag tag) {
        float x = 0.0f;
        float y = 0.0f;
        Map<String, String> attributes = tag.getAttributes();
        if (attributes != null) {
            try {
                x = Integer.parseInt(attributes.get(X));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                y = Integer.parseInt(attributes.get(Y));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ArrayList<Element> l = new ArrayList<Element>(0);
        Chunk c = new ChunkCssApplier().apply(new Chunk(""), tag);
        l.add(new Text(c, x, y, tag.getCSS(), this.split(attributes.get(DX)), this.split(attributes.get(DY))));
        return l;
    }

    private List<Integer> split(String str) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (str == null) {
            return null;
        }
        List<String> list = TagUtils.splitValueList(str);
        for (int i = 0; i < list.size(); ++i) {
            try {
                result.add(new Integer(list.get(i)));
                continue;
            }
            catch (NumberFormatException exp) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        ArrayList<Element> l = new ArrayList<Element>(1);
        String sanitized = content.trim();
        if (sanitized.length() > 0) {
            Chunk c = new ChunkCssApplier().apply(new Chunk(sanitized), tag);
            l.add(new Text(c, tag.getCSS(), null, null));
        }
        return l;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        ArrayList<Element> l = new ArrayList<Element>();
        if (currentContent.size() > 0) {
            ArrayList<Element> list = new ArrayList<Element>();
            for (Element element : currentContent) {
                if (element instanceof TextPathGroup) {
                    l.add(element);
                    continue;
                }
                if (!(element instanceof Text)) continue;
                list.add(element);
            }
            if (list.size() > 0) {
                TextGroup group = new TextGroup(list, 0.0f, 0.0f, 500.0f, 500.0f, tag.getCSS());
                l.add(group);
            }
        }
        return l;
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }

    @Override
    public boolean isElementWithId() {
        return true;
    }
}

