/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.tags;

import com.itextpdf.text.Element;
import com.itextpdf.text.Rectangle;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.svg.graphic.Svg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvgTag
extends AbstractTagProcessor {
    @Override
    public List<Element> start(WorkerContext ctx, Tag tag) {
        float height = 0.0f;
        float width = 0.0f;
        Rectangle r = null;
        String viewbox = "";
        Map<String, String> attributes = tag.getAttributes();
        if (attributes != null) {
            try {
                height = Float.parseFloat(attributes.get("height"));
            }
            catch (Exception exp) {
                // empty catch block
            }
            try {
                width = Float.parseFloat(attributes.get("width"));
            }
            catch (Exception exp) {
                // empty catch block
            }
            try {
                viewbox = attributes.get("viewBox");
                r = new Rectangle(0.0f, 0.0f);
                StringTokenizer st = new StringTokenizer(viewbox);
                if (st.hasMoreTokens()) {
                    r.setRight(Float.parseFloat(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    r.setBottom(-Float.parseFloat(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    r.setLeft(r.getRight() + Float.parseFloat(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    r.setTop(r.getBottom() + Float.parseFloat(st.nextToken()));
                }
                r.normalize();
            }
            catch (Exception exp) {
                // empty catch block
            }
        }
        if (r == null) {
            r = new Rectangle(width, height);
        } else if (width == 0.0f && height == 0.0f) {
            width = r.getWidth();
            height = r.getHeight();
        }
        ArrayList<Element> elems = new ArrayList<Element>();
        elems.add(new Svg(height, width, r, tag.getCSS()));
        return elems;
    }
}

