/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.tags;

import com.itextpdf.text.Element;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.svg.AbstractGraphicProcessor;
import com.itextpdf.tool.xml.svg.PathBean;
import com.itextpdf.tool.xml.svg.PathItem;
import com.itextpdf.tool.xml.svg.graphic.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyTag
extends AbstractGraphicProcessor {
    static final String POINTS = "points";

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        ArrayList<Element> elems = new ArrayList<Element>();
        Map<String, String> attributes = tag.getAttributes();
        if (attributes != null) {
            String str = attributes.get(POINTS);
            StringTokenizer tokenizer = new StringTokenizer(this.cleanPath(str), ", \t\n\r\f");
            ArrayList<String> values = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken().trim();
                values.add(value);
            }
            PathBean.Builder pathBuilder = new PathBean.Builder();
            if (values.size() % 2 == 1) {
                values.remove(values.size() - 1);
            }
            if (values.size() % 2 == 0) {
                for (int i = 0; i < values.size() / 2; ++i) {
                    PathItem.Builder itemBuilder = new PathItem.Builder();
                    if (i == 0) {
                        itemBuilder.setType('M');
                    } else {
                        itemBuilder.setType('L');
                    }
                    itemBuilder.addCoordinate((String)values.get(i * 2));
                    itemBuilder.addCoordinate((String)values.get(i * 2 + 1));
                    pathBuilder.setPathItem(itemBuilder.build());
                }
            }
            if (tag.getName().equals("polygon")) {
                PathItem.Builder itemBuilder = new PathItem.Builder();
                itemBuilder.setType('z');
                pathBuilder.setPathItem(itemBuilder.build());
            }
            elems.add(new Path(pathBuilder.build(), tag.getCSS()));
            return elems;
        }
        return new ArrayList<Element>(0);
    }

    protected String cleanPath(String path) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(path.charAt(0));
        for (int i = 1; i < path.length(); ++i) {
            if (Character.isLetter(path.charAt(i - 1)) && !Character.isLetter(path.charAt(i)) || !Character.isLetter(path.charAt(i - 1)) && Character.isLetter(path.charAt(i))) {
                buffer.append(' ');
            }
            buffer.append(path.charAt(i));
        }
        return buffer.toString();
    }

    @Override
    public boolean isElementWithId() {
        return true;
    }
}

