/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.parser.state;

import com.itextpdf.tool.xml.parser.State;
import com.itextpdf.tool.xml.parser.XMLParser;

public class TagAttributeState
implements State {
    protected final XMLParser parser;

    public TagAttributeState(XMLParser parser) {
        this.parser = parser;
    }

    public void process(char character) {
        if (character == '/') {
            this.parser.selectState().selfClosing();
        } else if (character == '=') {
            this.parser.memory().currentAttr(this.parser.bufferToString());
            this.parser.flush();
            this.parser.selectState().attributeValue();
        } else if (Character.isWhitespace(character)) {
            this.setAttribute();
        } else if (character == '>') {
            this.checkAttributeWithNoValue();
            this.parser.startElement();
            this.parser.flush();
            this.parser.selectState().inTag();
        } else if (this.parser.memory().hasCurrentAttribute() && !Character.isWhitespace(character)) {
            this.parser.memory().putCurrentAttrValue("");
            this.parser.append(character);
        } else {
            this.parser.append(character);
        }
    }

    protected void checkAttributeWithNoValue() {
        if (this.setAttribute()) {
            this.parser.memory().putCurrentAttrValue("");
        }
    }

    protected boolean setAttribute() {
        String attr = this.parser.bufferToString();
        if (attr.length() > 0) {
            this.parser.memory().currentAttr(attr);
            this.parser.flush();
            return true;
        }
        return false;
    }
}

