/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.JmsDestinationAccessor;
import org.springframework.util.ClassUtils;

public abstract class AbstractJmsListeningContainer
extends JmsDestinationAccessor
implements SmartLifecycle,
BeanNameAware,
DisposableBean {
    private String clientId;
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private String beanName;
    private Connection sharedConnection;
    private boolean sharedConnectionStarted = false;
    protected final Object sharedConnectionMonitor = new Object();
    private boolean active = false;
    private boolean running = false;
    private final List<Object> pausedTasks = new LinkedList<Object>();
    protected final Object lifecycleMonitor = new Object();

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected final String getBeanName() {
        return this.beanName;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.validateConfiguration();
        this.initialize();
    }

    protected void validateConfiguration() {
    }

    public void destroy() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws JmsException {
        try {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.active = true;
                this.lifecycleMonitor.notifyAll();
            }
            this.doInitialize();
        }
        catch (JMSException ex) {
            Object object = this.sharedConnectionMonitor;
            synchronized (object) {
                ConnectionFactoryUtils.releaseConnection(this.sharedConnection, this.getConnectionFactory(), this.autoStartup);
                this.sharedConnection = null;
            }
            throw this.convertJmsAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws JmsException {
        boolean wasRunning;
        this.logger.debug((Object)"Shutting down JMS listener container");
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            wasRunning = this.running;
            this.running = false;
            this.active = false;
            this.lifecycleMonitor.notifyAll();
        }
        if (wasRunning && this.sharedConnectionEnabled()) {
            try {
                this.stopSharedConnection();
            }
            catch (Throwable ex) {
                this.logger.debug((Object)"Could not stop JMS Connection on shutdown", ex);
            }
        }
        try {
            try {
                this.doShutdown();
            }
            catch (JMSException ex) {
                throw this.convertJmsAccessException(ex);
            }
        }
        catch (Throwable throwable) {
            if (this.sharedConnectionEnabled()) {
                Object object2 = this.sharedConnectionMonitor;
                synchronized (object2) {
                    ConnectionFactoryUtils.releaseConnection(this.sharedConnection, this.getConnectionFactory(), false);
                    this.sharedConnection = null;
                }
            }
            throw throwable;
        }
        if (this.sharedConnectionEnabled()) {
            Object object3 = this.sharedConnectionMonitor;
            synchronized (object3) {
                ConnectionFactoryUtils.releaseConnection(this.sharedConnection, this.getConnectionFactory(), false);
                this.sharedConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isActive() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    public void start() throws JmsException {
        try {
            this.doStart();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws JMSException {
        if (this.sharedConnectionEnabled()) {
            this.establishSharedConnection();
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = true;
            this.lifecycleMonitor.notifyAll();
            this.resumePausedTasks();
        }
        if (this.sharedConnectionEnabled()) {
            this.startSharedConnection();
        }
    }

    public void stop() throws JmsException {
        try {
            this.doStop();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws JMSException {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.lifecycleMonitor.notifyAll();
        }
        if (this.sharedConnectionEnabled()) {
            this.stopSharedConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running && this.runningAllowed();
        }
    }

    protected boolean runningAllowed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void establishSharedConnection() throws JMSException {
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            if (this.sharedConnection == null) {
                this.sharedConnection = this.createSharedConnection();
                this.logger.debug((Object)"Established shared JMS Connection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshSharedConnection() throws JMSException {
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            ConnectionFactoryUtils.releaseConnection(this.sharedConnection, this.getConnectionFactory(), this.sharedConnectionStarted);
            this.sharedConnection = null;
            this.sharedConnection = this.createSharedConnection();
            if (this.sharedConnectionStarted) {
                this.sharedConnection.start();
            }
        }
    }

    protected Connection createSharedConnection() throws JMSException {
        Connection con = this.createConnection();
        try {
            this.prepareSharedConnection(con);
            return con;
        }
        catch (JMSException ex) {
            JmsUtils.closeConnection(con);
            throw ex;
        }
    }

    protected void prepareSharedConnection(Connection connection) throws JMSException {
        String clientId = this.getClientId();
        if (clientId != null) {
            connection.setClientID(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSharedConnection() throws JMSException {
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            this.sharedConnectionStarted = true;
            if (this.sharedConnection != null) {
                try {
                    this.sharedConnection.start();
                }
                catch (IllegalStateException ex) {
                    this.logger.debug((Object)("Ignoring Connection start exception - assuming already started: " + (Object)((Object)ex)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSharedConnection() throws JMSException {
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            this.sharedConnectionStarted = false;
            if (this.sharedConnection != null) {
                try {
                    this.sharedConnection.stop();
                }
                catch (IllegalStateException ex) {
                    this.logger.debug((Object)("Ignoring Connection stop exception - assuming already stopped: " + (Object)((Object)ex)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Connection getSharedConnection() {
        if (!this.sharedConnectionEnabled()) {
            throw new java.lang.IllegalStateException("This listener container does not maintain a shared Connection");
        }
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            if (this.sharedConnection == null) {
                throw new SharedConnectionNotInitializedException("This listener container's shared Connection has not been initialized yet");
            }
            return this.sharedConnection;
        }
    }

    protected final boolean rescheduleTaskIfNecessary(Object task) {
        if (this.running) {
            try {
                this.doRescheduleTask(task);
            }
            catch (RuntimeException ex) {
                this.logRejectedTask(task, ex);
                this.pausedTasks.add(task);
            }
            return true;
        }
        if (this.active) {
            this.pausedTasks.add(task);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumePausedTasks() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.pausedTasks.isEmpty()) {
                Iterator<Object> it = this.pausedTasks.iterator();
                while (it.hasNext()) {
                    Object task = it.next();
                    try {
                        this.doRescheduleTask(task);
                        it.remove();
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("Resumed paused task: " + task));
                    }
                    catch (RuntimeException ex) {
                        this.logRejectedTask(task, ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPausedTaskCount() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.pausedTasks.size();
        }
    }

    protected void doRescheduleTask(Object task) {
        throw new UnsupportedOperationException(String.valueOf(ClassUtils.getShortName(this.getClass())) + " does not support rescheduling of tasks");
    }

    protected void logRejectedTask(Object task, RuntimeException ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listener container task [" + task + "] has been rejected and paused: " + ex));
        }
    }

    protected abstract boolean sharedConnectionEnabled();

    protected abstract void doInitialize() throws JMSException;

    protected abstract void doShutdown() throws JMSException;

    public static class SharedConnectionNotInitializedException
    extends RuntimeException {
        protected SharedConnectionNotInitializedException(String msg) {
            super(msg);
        }
    }
}

