/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.security;

import com.itextpdf.text.pdf.security.DigestAlgorithms;
import com.itextpdf.text.pdf.security.ExternalSignature;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;

public class PrivateKeySignature
implements ExternalSignature {
    private PrivateKey pk;
    private String hashAlgorithm;
    private String encryptionAlgorithm;
    private String provider;

    public PrivateKeySignature(PrivateKey pk, String hashAlgorithm, String provider) {
        this.pk = pk;
        this.provider = provider;
        this.hashAlgorithm = DigestAlgorithms.getDigest(DigestAlgorithms.getAllowedDigests(hashAlgorithm));
        this.encryptionAlgorithm = pk.getAlgorithm();
        if (this.encryptionAlgorithm.startsWith("EC")) {
            this.encryptionAlgorithm = "ECDSA";
        }
    }

    @Override
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public byte[] sign(byte[] b) throws GeneralSecurityException {
        String signMode = String.valueOf(this.hashAlgorithm) + "with" + this.encryptionAlgorithm;
        Signature sig = this.provider == null ? Signature.getInstance(signMode) : Signature.getInstance(signMode, this.provider);
        sig.initSign(this.pk);
        sig.update(b);
        return sig.sign();
    }
}

