/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.ByteMatrix;
import com.itextpdf.text.pdf.qrcode.EncodeHintType;
import com.itextpdf.text.pdf.qrcode.Encoder;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import com.itextpdf.text.pdf.qrcode.QRCode;
import com.itextpdf.text.pdf.qrcode.WriterException;
import java.util.Map;

public final class QRCodeWriter {
    private static final int QUIET_ZONE_SIZE = 4;

    public ByteMatrix encode(String contents, int width, int height) throws WriterException {
        return this.encode(contents, width, height, null);
    }

    public ByteMatrix encode(String contents, int width, int height, Map<EncodeHintType, Object> hints) throws WriterException {
        ErrorCorrectionLevel requestedECLevel;
        if (contents == null || contents.length() == 0) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + width + 'x' + height);
        }
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        if (hints != null && (requestedECLevel = (ErrorCorrectionLevel)hints.get(EncodeHintType.ERROR_CORRECTION)) != null) {
            errorCorrectionLevel = requestedECLevel;
        }
        QRCode code = new QRCode();
        Encoder.encode(contents, errorCorrectionLevel, hints, code);
        return QRCodeWriter.renderResult(code, width, height);
    }

    private static ByteMatrix renderResult(QRCode code, int width, int height) {
        int offset;
        ByteMatrix input = code.getMatrix();
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int qrWidth = inputWidth + 8;
        int qrHeight = inputHeight + 8;
        int outputWidth = Math.max(width, qrWidth);
        int outputHeight = Math.max(height, qrHeight);
        int multiple = Math.min(outputWidth / qrWidth, outputHeight / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        ByteMatrix output = new ByteMatrix(outputWidth, outputHeight);
        byte[][] outputArray = output.getArray();
        byte[] row = new byte[outputWidth];
        int y = 0;
        while (y < topPadding) {
            QRCodeWriter.setRowColor(outputArray[y], (byte)-1);
            ++y;
        }
        byte[][] inputArray = input.getArray();
        int y2 = 0;
        while (y2 < inputHeight) {
            int x = 0;
            while (x < leftPadding) {
                row[x] = -1;
                ++x;
            }
            int offset2 = leftPadding;
            int x2 = 0;
            while (x2 < inputWidth) {
                int value = inputArray[y2][x2] == 1 ? 0 : -1;
                int z = 0;
                while (z < multiple) {
                    row[offset2 + z] = value;
                    ++z;
                }
                offset2 += multiple;
                ++x2;
            }
            x2 = offset2 = leftPadding + inputWidth * multiple;
            while (x2 < outputWidth) {
                row[x2] = -1;
                ++x2;
            }
            offset2 = topPadding + y2 * multiple;
            int z = 0;
            while (z < multiple) {
                System.arraycopy(row, 0, outputArray[offset2 + z], 0, outputWidth);
                ++z;
            }
            ++y2;
        }
        int y3 = offset = topPadding + inputHeight * multiple;
        while (y3 < outputHeight) {
            QRCodeWriter.setRowColor(outputArray[y3], (byte)-1);
            ++y3;
        }
        return output;
    }

    private static void setRowColor(byte[] row, byte value) {
        int x = 0;
        while (x < row.length) {
            row[x] = value;
            ++x;
        }
    }
}

