/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.BitVector;
import com.itextpdf.text.pdf.qrcode.BlockPair;
import com.itextpdf.text.pdf.qrcode.ByteArray;
import com.itextpdf.text.pdf.qrcode.ByteMatrix;
import com.itextpdf.text.pdf.qrcode.CharacterSetECI;
import com.itextpdf.text.pdf.qrcode.EncodeHintType;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import com.itextpdf.text.pdf.qrcode.GF256;
import com.itextpdf.text.pdf.qrcode.MaskUtil;
import com.itextpdf.text.pdf.qrcode.MatrixUtil;
import com.itextpdf.text.pdf.qrcode.Mode;
import com.itextpdf.text.pdf.qrcode.QRCode;
import com.itextpdf.text.pdf.qrcode.ReedSolomonEncoder;
import com.itextpdf.text.pdf.qrcode.Version;
import com.itextpdf.text.pdf.qrcode.WriterException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class Encoder {
    private static final int[] ALPHANUMERIC_TABLE;
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    static {
        int[] nArray = new int[96];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[13] = -1;
        nArray[14] = -1;
        nArray[15] = -1;
        nArray[16] = -1;
        nArray[17] = -1;
        nArray[18] = -1;
        nArray[19] = -1;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[22] = -1;
        nArray[23] = -1;
        nArray[24] = -1;
        nArray[25] = -1;
        nArray[26] = -1;
        nArray[27] = -1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[30] = -1;
        nArray[31] = -1;
        nArray[32] = 36;
        nArray[33] = -1;
        nArray[34] = -1;
        nArray[35] = -1;
        nArray[36] = 37;
        nArray[37] = 38;
        nArray[38] = -1;
        nArray[39] = -1;
        nArray[40] = -1;
        nArray[41] = -1;
        nArray[42] = 39;
        nArray[43] = 40;
        nArray[44] = -1;
        nArray[45] = 41;
        nArray[46] = 42;
        nArray[47] = 43;
        nArray[49] = 1;
        nArray[50] = 2;
        nArray[51] = 3;
        nArray[52] = 4;
        nArray[53] = 5;
        nArray[54] = 6;
        nArray[55] = 7;
        nArray[56] = 8;
        nArray[57] = 9;
        nArray[58] = 44;
        nArray[59] = -1;
        nArray[60] = -1;
        nArray[61] = -1;
        nArray[62] = -1;
        nArray[63] = -1;
        nArray[64] = -1;
        nArray[65] = 10;
        nArray[66] = 11;
        nArray[67] = 12;
        nArray[68] = 13;
        nArray[69] = 14;
        nArray[70] = 15;
        nArray[71] = 16;
        nArray[72] = 17;
        nArray[73] = 18;
        nArray[74] = 19;
        nArray[75] = 20;
        nArray[76] = 21;
        nArray[77] = 22;
        nArray[78] = 23;
        nArray[79] = 24;
        nArray[80] = 25;
        nArray[81] = 26;
        nArray[82] = 27;
        nArray[83] = 28;
        nArray[84] = 29;
        nArray[85] = 30;
        nArray[86] = 31;
        nArray[87] = 32;
        nArray[88] = 33;
        nArray[89] = 34;
        nArray[90] = 35;
        nArray[91] = -1;
        nArray[92] = -1;
        nArray[93] = -1;
        nArray[94] = -1;
        nArray[95] = -1;
        ALPHANUMERIC_TABLE = nArray;
    }

    private Encoder() {
    }

    private static int calculateMaskPenalty(ByteMatrix matrix) {
        int penalty = 0;
        penalty += MaskUtil.applyMaskPenaltyRule1(matrix);
        penalty += MaskUtil.applyMaskPenaltyRule2(matrix);
        penalty += MaskUtil.applyMaskPenaltyRule3(matrix);
        return penalty += MaskUtil.applyMaskPenaltyRule4(matrix);
    }

    public static void encode(String content, ErrorCorrectionLevel ecLevel, QRCode qrCode) throws WriterException {
        Encoder.encode(content, ecLevel, null, qrCode);
    }

    public static void encode(String content, ErrorCorrectionLevel ecLevel, Map<EncodeHintType, Object> hints, QRCode qrCode) throws WriterException {
        CharacterSetECI eci;
        String encoding;
        String string = encoding = hints == null ? null : (String)hints.get(EncodeHintType.CHARACTER_SET);
        if (encoding == null) {
            encoding = DEFAULT_BYTE_MODE_ENCODING;
        }
        Mode mode = Encoder.chooseMode(content, encoding);
        BitVector dataBits = new BitVector();
        Encoder.appendBytes(content, mode, dataBits, encoding);
        int numInputBytes = dataBits.sizeInBytes();
        Encoder.initQRCode(numInputBytes, ecLevel, mode, qrCode);
        BitVector headerAndDataBits = new BitVector();
        if (mode == Mode.BYTE && !DEFAULT_BYTE_MODE_ENCODING.equals(encoding) && (eci = CharacterSetECI.getCharacterSetECIByName(encoding)) != null) {
            Encoder.appendECI(eci, headerAndDataBits);
        }
        Encoder.appendModeInfo(mode, headerAndDataBits);
        int numLetters = mode.equals(Mode.BYTE) ? dataBits.sizeInBytes() : content.length();
        Encoder.appendLengthInfo(numLetters, qrCode.getVersion(), mode, headerAndDataBits);
        headerAndDataBits.appendBitVector(dataBits);
        Encoder.terminateBits(qrCode.getNumDataBytes(), headerAndDataBits);
        BitVector finalBits = new BitVector();
        Encoder.interleaveWithECBytes(headerAndDataBits, qrCode.getNumTotalBytes(), qrCode.getNumDataBytes(), qrCode.getNumRSBlocks(), finalBits);
        ByteMatrix matrix = new ByteMatrix(qrCode.getMatrixWidth(), qrCode.getMatrixWidth());
        qrCode.setMaskPattern(Encoder.chooseMaskPattern(finalBits, qrCode.getECLevel(), qrCode.getVersion(), matrix));
        MatrixUtil.buildMatrix(finalBits, qrCode.getECLevel(), qrCode.getVersion(), qrCode.getMaskPattern(), matrix);
        qrCode.setMatrix(matrix);
        if (!qrCode.isValid()) {
            throw new WriterException("Invalid QR code: " + qrCode.toString());
        }
    }

    static int getAlphanumericCode(int code) {
        if (code < ALPHANUMERIC_TABLE.length) {
            return ALPHANUMERIC_TABLE[code];
        }
        return -1;
    }

    public static Mode chooseMode(String content) {
        return Encoder.chooseMode(content, null);
    }

    public static Mode chooseMode(String content, String encoding) {
        if ("Shift_JIS".equals(encoding)) {
            return Encoder.isOnlyDoubleByteKanji(content) ? Mode.KANJI : Mode.BYTE;
        }
        boolean hasNumeric = false;
        boolean hasAlphanumeric = false;
        int i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            if (c >= '0' && c <= '9') {
                hasNumeric = true;
            } else if (Encoder.getAlphanumericCode(c) != -1) {
                hasAlphanumeric = true;
            } else {
                return Mode.BYTE;
            }
            ++i;
        }
        if (hasAlphanumeric) {
            return Mode.ALPHANUMERIC;
        }
        if (hasNumeric) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean isOnlyDoubleByteKanji(String content) {
        byte[] bytes;
        try {
            bytes = content.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException uee) {
            return false;
        }
        int length = bytes.length;
        if (length % 2 != 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            int byte1 = bytes[i] & 0xFF;
            if (!(byte1 >= 129 && byte1 <= 159 || byte1 >= 224 && byte1 <= 235)) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    private static int chooseMaskPattern(BitVector bits, ErrorCorrectionLevel ecLevel, int version, ByteMatrix matrix) throws WriterException {
        int minPenalty = Integer.MAX_VALUE;
        int bestMaskPattern = -1;
        int maskPattern = 0;
        while (maskPattern < 8) {
            MatrixUtil.buildMatrix(bits, ecLevel, version, maskPattern, matrix);
            int penalty = Encoder.calculateMaskPenalty(matrix);
            if (penalty < minPenalty) {
                minPenalty = penalty;
                bestMaskPattern = maskPattern;
            }
            ++maskPattern;
        }
        return bestMaskPattern;
    }

    private static void initQRCode(int numInputBytes, ErrorCorrectionLevel ecLevel, Mode mode, QRCode qrCode) throws WriterException {
        qrCode.setECLevel(ecLevel);
        qrCode.setMode(mode);
        int versionNum = 1;
        while (versionNum <= 40) {
            Version version = Version.getVersionForNumber(versionNum);
            int numBytes = version.getTotalCodewords();
            Version.ECBlocks ecBlocks = version.getECBlocksForLevel(ecLevel);
            int numEcBytes = ecBlocks.getTotalECCodewords();
            int numRSBlocks = ecBlocks.getNumBlocks();
            int numDataBytes = numBytes - numEcBytes;
            if (numDataBytes >= numInputBytes + 3) {
                qrCode.setVersion(versionNum);
                qrCode.setNumTotalBytes(numBytes);
                qrCode.setNumDataBytes(numDataBytes);
                qrCode.setNumRSBlocks(numRSBlocks);
                qrCode.setNumECBytes(numEcBytes);
                qrCode.setMatrixWidth(version.getDimensionForVersion());
                return;
            }
            ++versionNum;
        }
        throw new WriterException("Cannot find proper rs block info (input data too big?)");
    }

    static void terminateBits(int numDataBytes, BitVector bits) throws WriterException {
        int i;
        int capacity = numDataBytes << 3;
        if (bits.size() > capacity) {
            throw new WriterException("data bits cannot fit in the QR Code" + bits.size() + " > " + capacity);
        }
        int i2 = 0;
        while (i2 < 4 && bits.size() < capacity) {
            bits.appendBit(0);
            ++i2;
        }
        int numBitsInLastByte = bits.size() % 8;
        if (numBitsInLastByte > 0) {
            int numPaddingBits = 8 - numBitsInLastByte;
            i = 0;
            while (i < numPaddingBits) {
                bits.appendBit(0);
                ++i;
            }
        }
        if (bits.size() % 8 != 0) {
            throw new WriterException("Number of bits is not a multiple of 8");
        }
        int numPaddingBytes = numDataBytes - bits.sizeInBytes();
        i = 0;
        while (i < numPaddingBytes) {
            if (i % 2 == 0) {
                bits.appendBits(236, 8);
            } else {
                bits.appendBits(17, 8);
            }
            ++i;
        }
        if (bits.size() != capacity) {
            throw new WriterException("Bits size does not equal capacity");
        }
    }

    static void getNumDataBytesAndNumECBytesForBlockID(int numTotalBytes, int numDataBytes, int numRSBlocks, int blockID, int[] numDataBytesInBlock, int[] numECBytesInBlock) throws WriterException {
        if (blockID >= numRSBlocks) {
            throw new WriterException("Block ID too large");
        }
        int numRsBlocksInGroup2 = numTotalBytes % numRSBlocks;
        int numRsBlocksInGroup1 = numRSBlocks - numRsBlocksInGroup2;
        int numTotalBytesInGroup1 = numTotalBytes / numRSBlocks;
        int numDataBytesInGroup1 = numDataBytes / numRSBlocks;
        int numEcBytesInGroup1 = numTotalBytesInGroup1 - numDataBytesInGroup1;
        int numTotalBytesInGroup2 = numTotalBytesInGroup1 + 1;
        int numDataBytesInGroup2 = numDataBytesInGroup1 + 1;
        int numEcBytesInGroup2 = numTotalBytesInGroup2 - numDataBytesInGroup2;
        if (numEcBytesInGroup1 != numEcBytesInGroup2) {
            throw new WriterException("EC bytes mismatch");
        }
        if (numRSBlocks != numRsBlocksInGroup1 + numRsBlocksInGroup2) {
            throw new WriterException("RS blocks mismatch");
        }
        if (numTotalBytes != (numDataBytesInGroup1 + numEcBytesInGroup1) * numRsBlocksInGroup1 + (numDataBytesInGroup2 + numEcBytesInGroup2) * numRsBlocksInGroup2) {
            throw new WriterException("Total bytes mismatch");
        }
        if (blockID < numRsBlocksInGroup1) {
            numDataBytesInBlock[0] = numDataBytesInGroup1;
            numECBytesInBlock[0] = numEcBytesInGroup1;
        } else {
            numDataBytesInBlock[0] = numDataBytesInGroup2;
            numECBytesInBlock[0] = numEcBytesInGroup2;
        }
    }

    static void interleaveWithECBytes(BitVector bits, int numTotalBytes, int numDataBytes, int numRSBlocks, BitVector result) throws WriterException {
        if (bits.sizeInBytes() != numDataBytes) {
            throw new WriterException("Number of bits and data bytes does not match");
        }
        int dataBytesOffset = 0;
        int maxNumDataBytes = 0;
        int maxNumEcBytes = 0;
        ArrayList<BlockPair> blocks = new ArrayList<BlockPair>(numRSBlocks);
        int i = 0;
        while (i < numRSBlocks) {
            int[] numDataBytesInBlock = new int[1];
            int[] numEcBytesInBlock = new int[1];
            Encoder.getNumDataBytesAndNumECBytesForBlockID(numTotalBytes, numDataBytes, numRSBlocks, i, numDataBytesInBlock, numEcBytesInBlock);
            ByteArray dataBytes = new ByteArray();
            dataBytes.set(bits.getArray(), dataBytesOffset, numDataBytesInBlock[0]);
            ByteArray ecBytes = Encoder.generateECBytes(dataBytes, numEcBytesInBlock[0]);
            blocks.add(new BlockPair(dataBytes, ecBytes));
            maxNumDataBytes = Math.max(maxNumDataBytes, dataBytes.size());
            maxNumEcBytes = Math.max(maxNumEcBytes, ecBytes.size());
            dataBytesOffset += numDataBytesInBlock[0];
            ++i;
        }
        if (numDataBytes != dataBytesOffset) {
            throw new WriterException("Data bytes does not match offset");
        }
        i = 0;
        while (i < maxNumDataBytes) {
            int j = 0;
            while (j < blocks.size()) {
                ByteArray dataBytes = ((BlockPair)blocks.get(j)).getDataBytes();
                if (i < dataBytes.size()) {
                    result.appendBits(dataBytes.at(i), 8);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < maxNumEcBytes) {
            int j = 0;
            while (j < blocks.size()) {
                ByteArray ecBytes = ((BlockPair)blocks.get(j)).getErrorCorrectionBytes();
                if (i < ecBytes.size()) {
                    result.appendBits(ecBytes.at(i), 8);
                }
                ++j;
            }
            ++i;
        }
        if (numTotalBytes != result.sizeInBytes()) {
            throw new WriterException("Interleaving error: " + numTotalBytes + " and " + result.sizeInBytes() + " differ.");
        }
    }

    static ByteArray generateECBytes(ByteArray dataBytes, int numEcBytesInBlock) {
        int numDataBytes = dataBytes.size();
        int[] toEncode = new int[numDataBytes + numEcBytesInBlock];
        int i = 0;
        while (i < numDataBytes) {
            toEncode[i] = dataBytes.at(i);
            ++i;
        }
        new ReedSolomonEncoder(GF256.QR_CODE_FIELD).encode(toEncode, numEcBytesInBlock);
        ByteArray ecBytes = new ByteArray(numEcBytesInBlock);
        int i2 = 0;
        while (i2 < numEcBytesInBlock) {
            ecBytes.set(i2, toEncode[numDataBytes + i2]);
            ++i2;
        }
        return ecBytes;
    }

    static void appendModeInfo(Mode mode, BitVector bits) {
        bits.appendBits(mode.getBits(), 4);
    }

    static void appendLengthInfo(int numLetters, int version, Mode mode, BitVector bits) throws WriterException {
        int numBits = mode.getCharacterCountBits(Version.getVersionForNumber(version));
        if (numLetters > (1 << numBits) - 1) {
            throw new WriterException(String.valueOf(numLetters) + "is bigger than" + ((1 << numBits) - 1));
        }
        bits.appendBits(numLetters, numBits);
    }

    static void appendBytes(String content, Mode mode, BitVector bits, String encoding) throws WriterException {
        if (mode.equals(Mode.NUMERIC)) {
            Encoder.appendNumericBytes(content, bits);
        } else if (mode.equals(Mode.ALPHANUMERIC)) {
            Encoder.appendAlphanumericBytes(content, bits);
        } else if (mode.equals(Mode.BYTE)) {
            Encoder.append8BitBytes(content, bits, encoding);
        } else if (mode.equals(Mode.KANJI)) {
            Encoder.appendKanjiBytes(content, bits);
        } else {
            throw new WriterException("Invalid mode: " + mode);
        }
    }

    static void appendNumericBytes(String content, BitVector bits) {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int num2;
            int num1 = content.charAt(i) - 48;
            if (i + 2 < length) {
                num2 = content.charAt(i + 1) - 48;
                int num3 = content.charAt(i + 2) - 48;
                bits.appendBits(num1 * 100 + num2 * 10 + num3, 10);
                i += 3;
                continue;
            }
            if (i + 1 < length) {
                num2 = content.charAt(i + 1) - 48;
                bits.appendBits(num1 * 10 + num2, 7);
                i += 2;
                continue;
            }
            bits.appendBits(num1, 4);
            ++i;
        }
    }

    static void appendAlphanumericBytes(String content, BitVector bits) throws WriterException {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int code1 = Encoder.getAlphanumericCode(content.charAt(i));
            if (code1 == -1) {
                throw new WriterException();
            }
            if (i + 1 < length) {
                int code2 = Encoder.getAlphanumericCode(content.charAt(i + 1));
                if (code2 == -1) {
                    throw new WriterException();
                }
                bits.appendBits(code1 * 45 + code2, 11);
                i += 2;
                continue;
            }
            bits.appendBits(code1, 6);
            ++i;
        }
    }

    static void append8BitBytes(String content, BitVector bits, String encoding) throws WriterException {
        byte[] bytes;
        try {
            bytes = content.getBytes(encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new WriterException(uee.toString());
        }
        int i = 0;
        while (i < bytes.length) {
            bits.appendBits(bytes[i], 8);
            ++i;
        }
    }

    static void appendKanjiBytes(String content, BitVector bits) throws WriterException {
        byte[] bytes;
        try {
            bytes = content.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException uee) {
            throw new WriterException(uee.toString());
        }
        int length = bytes.length;
        int i = 0;
        while (i < length) {
            int byte1 = bytes[i] & 0xFF;
            int byte2 = bytes[i + 1] & 0xFF;
            int code = byte1 << 8 | byte2;
            int subtracted = -1;
            if (code >= 33088 && code <= 40956) {
                subtracted = code - 33088;
            } else if (code >= 57408 && code <= 60351) {
                subtracted = code - 49472;
            }
            if (subtracted == -1) {
                throw new WriterException("Invalid byte sequence");
            }
            int encoded = (subtracted >> 8) * 192 + (subtracted & 0xFF);
            bits.appendBits(encoded, 13);
            i += 2;
        }
    }

    private static void appendECI(CharacterSetECI eci, BitVector bits) {
        bits.appendBits(Mode.ECI.getBits(), 4);
        bits.appendBits(eci.getValue(), 8);
    }
}

