/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.ocg;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OCGParser {
    public static final String DEFAULTOPERATOR = "DefaultOperator";
    protected static Map<String, PdfOperator> operators = null;
    protected static ByteArrayOutputStream baos;
    protected int mc_balance = 0;
    protected Set<PdfName> xobj;
    protected Set<String> ocgs;
    protected PdfDictionary properties = null;

    public OCGParser(Set<String> ocgs) {
        this.populateOperators();
        this.ocgs = ocgs;
    }

    public void parse(PRStream stream, PdfDictionary resources) throws IOException {
        baos = new ByteArrayOutputStream();
        this.properties = resources.getAsDict(PdfName.PROPERTIES);
        this.xobj = new HashSet<PdfName>();
        PdfDictionary xobjects = resources.getAsDict(PdfName.XOBJECT);
        if (xobjects != null) {
            for (PdfName name : xobjects.getKeys()) {
                PdfString ocname;
                PRStream xobject = (PRStream)xobjects.getAsStream(name);
                PdfDictionary oc = xobject.getAsDict(PdfName.OC);
                if (oc == null || (ocname = oc.getAsString(PdfName.NAME)) == null || !this.ocgs.contains(ocname.toString())) continue;
                this.xobj.add(name);
            }
            for (PdfName name : this.xobj) {
                xobjects.remove(name);
            }
        }
        try {
            byte[] contentBytes = PdfReader.getStreamBytes(stream);
            PRTokeniser tokeniser = new PRTokeniser(new RandomAccessFileOrArray(contentBytes));
            PdfContentParser ps = new PdfContentParser(tokeniser);
            ArrayList<PdfObject> operands = new ArrayList<PdfObject>();
            while (ps.parse(operands).size() > 0) {
                PdfLiteral operator = (PdfLiteral)operands.get(operands.size() - 1);
                OCGParser.processOperator(this, operator, operands);
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        baos.flush();
        baos.close();
        stream.setData(baos.toByteArray());
    }

    protected static void processOperator(OCGParser parser, PdfLiteral operator, List<PdfObject> operands) throws Exception {
        PdfOperator op = operators.get(operator.toString());
        if (op == null) {
            op = operators.get(DEFAULTOPERATOR);
        }
        op.process(parser, operator, operands);
    }

    protected void populateOperators() {
        if (operators != null) {
            return;
        }
        operators = new HashMap<String, PdfOperator>();
        operators.put(DEFAULTOPERATOR, new CopyContentOperator());
        PathConstructionOrPaintingOperator opConstructionPainting = new PathConstructionOrPaintingOperator();
        operators.put("m", opConstructionPainting);
        operators.put("l", opConstructionPainting);
        operators.put("c", opConstructionPainting);
        operators.put("v", opConstructionPainting);
        operators.put("y", opConstructionPainting);
        operators.put("h", opConstructionPainting);
        operators.put("re", opConstructionPainting);
        operators.put("S", opConstructionPainting);
        operators.put("s", opConstructionPainting);
        operators.put("f", opConstructionPainting);
        operators.put("F", opConstructionPainting);
        operators.put("f*", opConstructionPainting);
        operators.put("B", opConstructionPainting);
        operators.put("B*", opConstructionPainting);
        operators.put("b", opConstructionPainting);
        operators.put("b*", opConstructionPainting);
        operators.put("n", opConstructionPainting);
        operators.put("W", opConstructionPainting);
        operators.put("W*", opConstructionPainting);
        GraphicsOperator graphics = new GraphicsOperator();
        operators.put("q", graphics);
        operators.put("Q", graphics);
        operators.put("w", graphics);
        operators.put("J", graphics);
        operators.put("j", graphics);
        operators.put("M", graphics);
        operators.put("d", graphics);
        operators.put("ri", graphics);
        operators.put("i", graphics);
        operators.put("gs", graphics);
        operators.put("cm", graphics);
        operators.put("g", graphics);
        operators.put("G", graphics);
        operators.put("rg", graphics);
        operators.put("RG", graphics);
        operators.put("k", graphics);
        operators.put("K", graphics);
        operators.put("cs", graphics);
        operators.put("CS", graphics);
        operators.put("sc", graphics);
        operators.put("SC", graphics);
        operators.put("scn", graphics);
        operators.put("SCN", graphics);
        operators.put("sh", graphics);
        XObjectOperator xObject = new XObjectOperator();
        operators.put("Do", xObject);
        InlineImageOperator inlineImage = new InlineImageOperator();
        operators.put("BI", inlineImage);
        operators.put("EI", inlineImage);
        TextOperator text = new TextOperator();
        operators.put("BT", text);
        operators.put("ID", text);
        operators.put("ET", text);
        operators.put("Tc", text);
        operators.put("Tw", text);
        operators.put("Tz", text);
        operators.put("TL", text);
        operators.put("Tf", text);
        operators.put("Tr", text);
        operators.put("Ts", text);
        operators.put("Td", text);
        operators.put("TD", text);
        operators.put("Tm", text);
        operators.put("T*", text);
        operators.put("Tj", text);
        operators.put("'", text);
        operators.put("\"", text);
        operators.put("TJ", text);
        MarkedContentOperator markedContent = new MarkedContentOperator();
        operators.put("BMC", markedContent);
        operators.put("BDC", markedContent);
        operators.put("EMC", markedContent);
    }

    protected boolean isVisible(List<PdfObject> operands) {
        return operands.size() <= 1 || !this.xobj.contains(operands.get(0));
    }

    protected boolean isToRemoved() {
        return this.mc_balance > 0;
    }

    protected void checkMarkedContentStart(PdfName ocref) {
        if (this.mc_balance > 0) {
            ++this.mc_balance;
            return;
        }
        PdfDictionary ocdict = this.properties.getAsDict(ocref);
        if (ocdict == null) {
            return;
        }
        PdfString ocname = ocdict.getAsString(PdfName.NAME);
        if (ocname == null) {
            return;
        }
        if (this.ocgs.contains(ocname.toString())) {
            ++this.mc_balance;
        }
    }

    protected void checkMarkedContentEnd() {
        if (this.mc_balance > 0) {
            --this.mc_balance;
        }
    }

    protected void process(PdfLiteral operator, List<PdfObject> operands, boolean removable) throws IOException {
        if (removable && this.isToRemoved()) {
            return;
        }
        operands.remove(operator);
        for (PdfObject o : operands) {
            this.printsp(o);
        }
        this.println(operator);
    }

    protected void printsp(PdfObject o) throws IOException {
        o.toPdf(null, baos);
        baos.write(32);
    }

    protected void println(PdfObject o) throws IOException {
        o.toPdf(null, baos);
        baos.write(10);
    }

    private static class CopyContentOperator
    implements PdfOperator {
        private CopyContentOperator() {
        }

        @Override
        public void process(OCGParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            parser.process(operator, operands, true);
        }
    }

    private static class GraphicsOperator
    implements PdfOperator {
        private GraphicsOperator() {
        }

        @Override
        public void process(OCGParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            parser.process(operator, operands, false);
        }
    }

    private static class InlineImageOperator
    implements PdfOperator {
        private InlineImageOperator() {
        }

        @Override
        public void process(OCGParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            parser.process(operator, operands, true);
        }
    }

    private static class MarkedContentOperator
    implements PdfOperator {
        private MarkedContentOperator() {
        }

        @Override
        public void process(OCGParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            if ("BDC".equals(operator.toString()) && operands.size() > 1 && PdfName.OC.equals(operands.get(0))) {
                parser.checkMarkedContentStart((PdfName)operands.get(1));
            } else if ("EMC".equals(operator.toString())) {
                parser.checkMarkedContentEnd();
            } else if ("BMC".equals(operator.toString())) {
                parser.checkMarkedContentStart(null);
            }
            parser.process(operator, operands, true);
        }
    }

    private static class PathConstructionOrPaintingOperator
    implements PdfOperator {
        private PathConstructionOrPaintingOperator() {
        }

        @Override
        public void process(OCGParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            parser.process(operator, operands, true);
        }
    }

    public static interface PdfOperator {
        public void process(OCGParser var1, PdfLiteral var2, List<PdfObject> var3) throws IOException;
    }

    private static class TextOperator
    implements PdfOperator {
        private TextOperator() {
        }

        @Override
        public void process(OCGParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            parser.process(operator, operands, true);
        }
    }

    private static class XObjectOperator
    implements PdfOperator {
        private XObjectOperator() {
        }

        @Override
        public void process(OCGParser parser, PdfLiteral operator, List<PdfObject> operands) throws IOException {
            if (parser.isVisible(operands)) {
                parser.process(operator, operands, true);
            }
        }
    }
}

