/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.internal;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.PdfAConformanceException;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfImage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.interfaces.PdfAConformance;

public class PdfAConformanceImp
implements PdfAConformance {
    private PdfAConformanceLevel conformanceLevel;

    public static void checkPdfAConformance(PdfWriter writer, int key, Object obj1) {
        if (writer == null || !writer.isPdfIso()) {
            return;
        }
        switch (key) {
            case 4: {
                BaseFont bf = (BaseFont)obj1;
                if (bf.getFontType() == 4) {
                    PdfStream prs = null;
                    PdfDictionary fontDictionary = ((DocumentFont)bf).getFontDictionary();
                    PdfDictionary fontDescriptor = fontDictionary.getAsDict(PdfName.FONTDESCRIPTOR);
                    if (fontDescriptor != null) {
                        prs = fontDescriptor.getAsStream(PdfName.FONTFILE);
                        if (prs == null) {
                            prs = fontDescriptor.getAsStream(PdfName.FONTFILE2);
                        }
                        if (prs == null) {
                            prs = fontDescriptor.getAsStream(PdfName.FONTFILE3);
                        }
                    }
                    if (prs != null) break;
                    throw new PdfAConformanceException(MessageLocalization.getComposedMessage("all.the.fonts.must.be.embedded.this.one.isn.t.1", ((BaseFont)obj1).getPostscriptFontName()));
                }
                if (bf.isEmbedded()) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage("all.the.fonts.must.be.embedded.this.one.isn.t.1", ((BaseFont)obj1).getPostscriptFontName()));
            }
            case 5: {
                PdfImage image = (PdfImage)obj1;
                if (image.get(PdfName.SMASK) == null) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage("the.smask.key.is.not.allowed.in.images", new Object[0]));
            }
            case 6: {
                PdfDictionary gs = (PdfDictionary)obj1;
                PdfObject obj = gs.get(PdfName.BM);
                if (obj != null && !PdfGState.BM_NORMAL.equals(obj) && !PdfGState.BM_COMPATIBLE.equals(obj)) {
                    throw new PdfAConformanceException(MessageLocalization.getComposedMessage("blend.mode.1.not.allowed", obj.toString()));
                }
                obj = gs.get(PdfName.CA);
                double v = 0.0;
                if (obj != null && (v = ((PdfNumber)obj).doubleValue()) != 1.0) {
                    throw new PdfAConformanceException(MessageLocalization.getComposedMessage("transparency.is.not.allowed.ca.eq.1", String.valueOf(v)));
                }
                obj = gs.get(PdfName.ca);
                v = 0.0;
                if (obj == null || (v = ((PdfNumber)obj).doubleValue()) == 1.0) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage("transparency.is.not.allowed.ca.eq.1", String.valueOf(v)));
            }
            case 7: {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage("layers.are.not.allowed", new Object[0]));
            }
        }
    }

    @Override
    public PdfAConformanceLevel getConformanceLevel() {
        return this.conformanceLevel;
    }

    @Override
    public void setConformanceLevel(PdfAConformanceLevel conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
    }

    @Override
    public boolean isPdfIso() {
        return true;
    }
}

