/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.fonts.cmaps;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.fonts.cmaps.AbstractCMap;
import com.itextpdf.text.pdf.fonts.cmaps.CidLocation;
import java.io.IOException;
import java.util.ArrayList;

public class CMapParserEx {
    private static final PdfName CMAPNAME = new PdfName("CMapName");
    private static final String DEF = "def";
    private static final String ENDCIDRANGE = "endcidrange";
    private static final String ENDCIDCHAR = "endcidchar";
    private static final String ENDBFRANGE = "endbfrange";
    private static final String ENDBFCHAR = "endbfchar";
    private static final String USECMAP = "usecmap";
    private static final int MAXLEVEL = 10;

    public static void parseCid(String cmapName, AbstractCMap cmap, CidLocation location) throws IOException {
        CMapParserEx.parseCid(cmapName, cmap, location, 0);
    }

    private static void parseCid(String cmapName, AbstractCMap cmap, CidLocation location, int level) throws IOException {
        if (level >= 10) {
            return;
        }
        PRTokeniser inp = location.getLocation(cmapName);
        try {
            ArrayList<PdfObject> list = new ArrayList<PdfObject>();
            PdfContentParser cp = new PdfContentParser(inp);
            int maxExc = 50;
            block7: while (true) {
                try {
                    cp.parse(list);
                }
                catch (Exception ex) {
                    if (--maxExc >= 0) continue;
                    break;
                }
                if (list.isEmpty()) {
                    break;
                }
                String last = list.get(list.size() - 1).toString();
                if (level == 0 && list.size() == 3 && last.equals(DEF)) {
                    PdfObject key = list.get(0);
                    if (PdfName.REGISTRY.equals(key)) {
                        cmap.setRegistry(list.get(1).toString());
                        continue;
                    }
                    if (PdfName.ORDERING.equals(key)) {
                        cmap.setOrdering(list.get(1).toString());
                        continue;
                    }
                    if (CMAPNAME.equals(key)) {
                        cmap.setName(list.get(1).toString());
                        continue;
                    }
                    if (!PdfName.SUPPLEMENT.equals(key)) continue;
                    try {
                        cmap.setSupplement(((PdfNumber)list.get(1)).intValue());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if ((last.equals(ENDCIDCHAR) || last.equals(ENDBFCHAR)) && list.size() >= 3) {
                    int lmax = list.size() - 2;
                    int k = 0;
                    while (true) {
                        if (k >= lmax) continue block7;
                        if (list.get(k) instanceof PdfString) {
                            cmap.addChar((PdfString)list.get(k), list.get(k + 1));
                        }
                        k += 2;
                    }
                }
                if ((last.equals(ENDCIDRANGE) || last.equals(ENDBFRANGE)) && list.size() >= 4) {
                    int lmax = list.size() - 3;
                    int k = 0;
                    while (true) {
                        if (k >= lmax) continue block7;
                        if (list.get(k) instanceof PdfString && list.get(k + 1) instanceof PdfString) {
                            cmap.addRange((PdfString)list.get(k), (PdfString)list.get(k + 1), list.get(k + 2));
                        }
                        k += 3;
                    }
                }
                if (!last.equals(USECMAP) || list.size() != 2 || !(list.get(0) instanceof PdfName)) continue;
                CMapParserEx.parseCid(PdfName.decodeName(list.get(0).toString()), cmap, location, level + 1);
            }
        }
        finally {
            inp.close();
        }
    }

    private static void encodeSequence(int size, byte[] seqs, char cid, ArrayList<char[]> planes) {
        int one;
        --size;
        int nextPlane = 0;
        int idx = 0;
        while (idx < size) {
            int one2;
            char[] plane = planes.get(nextPlane);
            char c = plane[one2 = seqs[idx] & 0xFF];
            if (c != '\u0000' && (c & 0x8000) == 0) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("inconsistent.mapping", new Object[0]));
            }
            if (c == '\u0000') {
                planes.add(new char[256]);
                plane[one2] = c = (char)(planes.size() - 1 | 0x8000);
            }
            nextPlane = c & Short.MAX_VALUE;
            ++idx;
        }
        char[] plane = planes.get(nextPlane);
        char c = plane[one = seqs[size] & 0xFF];
        if ((c & 0x8000) != 0) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("inconsistent.mapping", new Object[0]));
        }
        plane[one] = cid;
    }
}

