/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.events;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class IndexEvents
extends PdfPageEventHelper {
    private Map<String, Integer> indextag = new TreeMap<String, Integer>();
    private long indexcounter = 0L;
    private List<Entry> indexentry = new ArrayList<Entry>();
    private Comparator<Entry> comparator = new Comparator<Entry>(){

        @Override
        public int compare(Entry en1, Entry en2) {
            int rt = 0;
            if (en1.getIn1() != null && en2.getIn1() != null && (rt = en1.getIn1().compareToIgnoreCase(en2.getIn1())) == 0 && en1.getIn2() != null && en2.getIn2() != null && (rt = en1.getIn2().compareToIgnoreCase(en2.getIn2())) == 0 && en1.getIn3() != null && en2.getIn3() != null) {
                rt = en1.getIn3().compareToIgnoreCase(en2.getIn3());
            }
            return rt;
        }
    };

    @Override
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {
        this.indextag.put(text, writer.getPageNumber());
    }

    public Chunk create(String text, String in1, String in2, String in3) {
        Chunk chunk = new Chunk(text);
        String tag = "idx_" + this.indexcounter++;
        chunk.setGenericTag(tag);
        chunk.setLocalDestination(tag);
        Entry entry = new Entry(in1, in2, in3, tag);
        this.indexentry.add(entry);
        return chunk;
    }

    public Chunk create(String text, String in1) {
        return this.create(text, in1, "", "");
    }

    public Chunk create(String text, String in1, String in2) {
        return this.create(text, in1, in2, "");
    }

    public void create(Chunk text, String in1, String in2, String in3) {
        String tag = "idx_" + this.indexcounter++;
        text.setGenericTag(tag);
        text.setLocalDestination(tag);
        Entry entry = new Entry(in1, in2, in3, tag);
        this.indexentry.add(entry);
    }

    public void create(Chunk text, String in1) {
        this.create(text, in1, "", "");
    }

    public void create(Chunk text, String in1, String in2) {
        this.create(text, in1, in2, "");
    }

    public void setComparator(Comparator<Entry> aComparator) {
        this.comparator = aComparator;
    }

    public List<Entry> getSortedEntries() {
        HashMap<String, Entry> grouped = new HashMap<String, Entry>();
        int i = 0;
        while (i < this.indexentry.size()) {
            Entry e = this.indexentry.get(i);
            String key = e.getKey();
            Entry master = (Entry)grouped.get(key);
            if (master != null) {
                master.addPageNumberAndTag(e.getPageNumber(), e.getTag());
            } else {
                e.addPageNumberAndTag(e.getPageNumber(), e.getTag());
                grouped.put(key, e);
            }
            ++i;
        }
        ArrayList<Entry> sorted = new ArrayList<Entry>(grouped.values());
        Collections.sort(sorted, this.comparator);
        return sorted;
    }

    public class Entry {
        private String in1;
        private String in2;
        private String in3;
        private String tag;
        private List<Integer> pagenumbers = new ArrayList<Integer>();
        private List<String> tags = new ArrayList<String>();

        public Entry(String aIn1, String aIn2, String aIn3, String aTag) {
            this.in1 = aIn1;
            this.in2 = aIn2;
            this.in3 = aIn3;
            this.tag = aTag;
        }

        public String getIn1() {
            return this.in1;
        }

        public String getIn2() {
            return this.in2;
        }

        public String getIn3() {
            return this.in3;
        }

        public String getTag() {
            return this.tag;
        }

        public int getPageNumber() {
            int rt = -1;
            Integer i = (Integer)IndexEvents.this.indextag.get(this.tag);
            if (i != null) {
                rt = i;
            }
            return rt;
        }

        public void addPageNumberAndTag(int number, String tag) {
            this.pagenumbers.add(number);
            this.tags.add(tag);
        }

        public String getKey() {
            return String.valueOf(this.in1) + "!" + this.in2 + "!" + this.in3;
        }

        public List<Integer> getPagenumbers() {
            return this.pagenumbers;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.in1).append(' ');
            buf.append(this.in2).append(' ');
            buf.append(this.in3).append(' ');
            int i = 0;
            while (i < this.pagenumbers.size()) {
                buf.append(this.pagenumbers.get(i)).append(' ');
                ++i;
            }
            return buf.toString();
        }
    }
}

