/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.collection;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;

public class PdfCollectionSort
extends PdfDictionary {
    public PdfCollectionSort(String key) {
        super(PdfName.COLLECTIONSORT);
        this.put(PdfName.S, new PdfName(key));
    }

    public PdfCollectionSort(String[] keys) {
        super(PdfName.COLLECTIONSORT);
        PdfArray array = new PdfArray();
        int i = 0;
        while (i < keys.length) {
            array.add(new PdfName(keys[i]));
            ++i;
        }
        this.put(PdfName.S, array);
    }

    public void setSortOrder(boolean ascending) {
        PdfObject o = this.get(PdfName.S);
        if (!(o instanceof PdfName)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("you.have.to.define.a.boolean.array.for.this.collection.sort.dictionary", new Object[0]));
        }
        this.put(PdfName.A, new PdfBoolean(ascending));
    }

    public void setSortOrder(boolean[] ascending) {
        PdfArray array;
        PdfObject o = this.get(PdfName.S);
        if (o instanceof PdfArray) {
            if (((PdfArray)o).size() != ascending.length) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.number.of.booleans.in.this.array.doesn.t.correspond.with.the.number.of.fields", new Object[0]));
            }
            array = new PdfArray();
            int i = 0;
            while (i < ascending.length) {
                array.add(new PdfBoolean(ascending[i]));
                ++i;
            }
        } else {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("you.need.a.single.boolean.for.this.collection.sort.dictionary", new Object[0]));
        }
        this.put(PdfName.A, array);
    }
}

