/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Anchor;
import com.itextpdf.text.Annotation;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.ListLabel;
import com.itextpdf.text.MarkedObject;
import com.itextpdf.text.MarkedSection;
import com.itextpdf.text.Meta;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.Section;
import com.itextpdf.text.Version;
import com.itextpdf.text.api.WriterOperation;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.FloatLayout;
import com.itextpdf.text.pdf.PageResources;
import com.itextpdf.text.pdf.PdfAcroForm;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfChunk;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfContents;
import com.itextpdf.text.pdf.PdfDate;
import com.itextpdf.text.pdf.PdfDestination;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDiv;
import com.itextpdf.text.pdf.PdfEncodings;
import com.itextpdf.text.pdf.PdfEncryption;
import com.itextpdf.text.pdf.PdfException;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfFont;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfLine;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNameTree;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfOutline;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPage;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageLabels;
import com.itextpdf.text.pdf.PdfRectangle;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfStructureElement;
import com.itextpdf.text.pdf.PdfTextArray;
import com.itextpdf.text.pdf.PdfTransition;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.PdfXConformanceException;
import com.itextpdf.text.pdf.collection.PdfCollection;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import com.itextpdf.text.pdf.internal.PdfAnnotationsImp;
import com.itextpdf.text.pdf.internal.PdfViewerPreferencesImp;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class PdfDocument
extends Document {
    protected PdfWriter writer;
    protected HashMap<UUID, PdfStructureElement> structElements = new HashMap();
    protected boolean openMCDocument = false;
    protected PdfContentByte text;
    protected PdfContentByte graphics;
    protected float leading = 0.0f;
    protected int alignment = 0;
    protected float currentHeight = 0.0f;
    protected boolean isSectionTitle = false;
    protected int leadingCount = 0;
    protected PdfAction anchorAction = null;
    protected int textEmptySize;
    protected float nextMarginLeft;
    protected float nextMarginRight;
    protected float nextMarginTop;
    protected float nextMarginBottom;
    protected boolean firstPageEvent = true;
    protected PdfLine line = null;
    protected ArrayList<PdfLine> lines = new ArrayList();
    protected int lastElementType = -1;
    static final String hangingPunctuation = ".,;:'";
    protected Indentation indentation = new Indentation();
    protected PdfInfo info = new PdfInfo();
    protected PdfOutline rootOutline;
    protected PdfOutline currentOutline;
    protected PdfViewerPreferencesImp viewerPreferences = new PdfViewerPreferencesImp();
    protected PdfPageLabels pageLabels;
    protected TreeMap<String, Destination> localDestinations = new TreeMap();
    int jsCounter;
    protected HashMap<String, PdfObject> documentLevelJS = new HashMap();
    protected static final DecimalFormat SIXTEEN_DIGITS = new DecimalFormat("0000000000000000");
    protected HashMap<String, PdfObject> documentFileAttachment = new HashMap();
    protected String openActionName;
    protected PdfAction openActionAction;
    protected PdfDictionary additionalActions;
    protected PdfCollection collection;
    PdfAnnotationsImp annotationsImp;
    protected PdfString language;
    protected int markPoint;
    protected Rectangle nextPageSize = null;
    protected HashMap<String, PdfRectangle> thisBoxSize = new HashMap();
    protected HashMap<String, PdfRectangle> boxSize = new HashMap();
    private boolean pageEmpty = true;
    protected PdfDictionary pageAA = null;
    protected PageResources pageResources;
    protected boolean strictImageSequence = false;
    protected float imageEnd = -1.0f;
    protected Image imageWait = null;
    private ArrayList<Element> floatingElements = new ArrayList();

    public PdfDocument() {
        this.addProducer();
        this.addCreationDate();
    }

    public void addWriter(PdfWriter writer) throws DocumentException {
        if (this.writer == null) {
            this.writer = writer;
            this.annotationsImp = new PdfAnnotationsImp(writer);
            return;
        }
        throw new DocumentException(MessageLocalization.getComposedMessage("you.can.only.add.a.writer.to.a.pdfdocument.once", new Object[0]));
    }

    public float getLeading() {
        return this.leading;
    }

    void setLeading(float leading) {
        this.leading = leading;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean add(Element element) throws DocumentException {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        try {
            if (element.type() != 37) {
                this.flushFloatingElements();
            }
            block1 : switch (element.type()) {
                case 0: {
                    this.info.addkey(((Meta)element).getName(), ((Meta)element).getContent());
                    break;
                }
                case 1: {
                    this.info.addTitle(((Meta)element).getContent());
                    break;
                }
                case 2: {
                    this.info.addSubject(((Meta)element).getContent());
                    break;
                }
                case 3: {
                    this.info.addKeywords(((Meta)element).getContent());
                    break;
                }
                case 4: {
                    this.info.addAuthor(((Meta)element).getContent());
                    break;
                }
                case 7: {
                    this.info.addCreator(((Meta)element).getContent());
                    break;
                }
                case 8: {
                    this.setLanguage(((Meta)element).getContent());
                    break;
                }
                case 5: {
                    this.info.addProducer();
                    break;
                }
                case 6: {
                    this.info.addCreationDate();
                    break;
                }
                case 10: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    PdfChunk chunk = new PdfChunk((Chunk)element, this.anchorAction);
                    while (true) {
                        PdfChunk overflow;
                        if ((overflow = this.line.add(chunk)) == null) {
                            this.pageEmpty = false;
                            if (!chunk.isAttribute("NEWPAGE")) break block1;
                            this.newPage();
                            break block1;
                        }
                        this.carriageReturn();
                        boolean newlineSplit = chunk.isNewlineSplit();
                        chunk = overflow;
                        if (newlineSplit) continue;
                        chunk.trimFirstSpace();
                    }
                }
                case 17: {
                    ++this.leadingCount;
                    Anchor anchor = (Anchor)element;
                    String url = anchor.getReference();
                    this.leading = anchor.getLeading();
                    if (url != null) {
                        this.anchorAction = new PdfAction(url);
                    }
                    element.process(this);
                    this.anchorAction = null;
                    --this.leadingCount;
                    break;
                }
                case 29: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    Annotation annot = (Annotation)element;
                    Rectangle rect = new Rectangle(0.0f, 0.0f);
                    if (this.line != null) {
                        rect = new Rectangle(annot.llx(this.indentRight() - this.line.widthLeft()), annot.ury(this.indentTop() - this.currentHeight - 20.0f), annot.urx(this.indentRight() - this.line.widthLeft() + 20.0f), annot.lly(this.indentTop() - this.currentHeight));
                    }
                    PdfAnnotation an = PdfAnnotationsImp.convertAnnotation(this.writer, annot, rect);
                    this.annotationsImp.addPlainAnnotation(an);
                    this.pageEmpty = false;
                    break;
                }
                case 11: {
                    ++this.leadingCount;
                    this.leading = ((Phrase)element).getTotalLeading();
                    element.process(this);
                    --this.leadingCount;
                    break;
                }
                case 12: {
                    ++this.leadingCount;
                    Paragraph paragraph = (Paragraph)element;
                    if (PdfDocument.isTagged(this.writer)) {
                        this.flushLines();
                        this.text.openMCBlock(paragraph);
                    }
                    this.addSpacing(paragraph.getSpacingBefore(), this.leading, paragraph.getFont());
                    this.alignment = paragraph.getAlignment();
                    this.leading = paragraph.getTotalLeading();
                    this.carriageReturn();
                    if (this.currentHeight + this.line.height() + this.leading > this.indentTop() - this.indentBottom()) {
                        this.newPage();
                    }
                    this.indentation.indentLeft += paragraph.getIndentationLeft();
                    this.indentation.indentRight += paragraph.getIndentationRight();
                    this.carriageReturn();
                    PdfPageEvent pageEvent = this.writer.getPageEvent();
                    if (pageEvent != null && !this.isSectionTitle) {
                        pageEvent.onParagraph(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    if (paragraph.getKeepTogether()) {
                        this.carriageReturn();
                        PdfPTable table = new PdfPTable(1);
                        table.setWidthPercentage(100.0f);
                        PdfPCell cell = new PdfPCell();
                        cell.addElement(paragraph);
                        cell.setBorder(0);
                        cell.setPadding(0.0f);
                        table.addCell(cell);
                        this.indentation.indentLeft -= paragraph.getIndentationLeft();
                        this.indentation.indentRight -= paragraph.getIndentationRight();
                        this.add(table);
                        this.indentation.indentLeft += paragraph.getIndentationLeft();
                        this.indentation.indentRight += paragraph.getIndentationRight();
                    } else {
                        this.line.setExtraIndent(paragraph.getFirstLineIndent());
                        element.process(this);
                        this.carriageReturn();
                        this.addSpacing(paragraph.getSpacingAfter(), paragraph.getTotalLeading(), paragraph.getFont());
                    }
                    if (pageEvent != null && !this.isSectionTitle) {
                        pageEvent.onParagraphEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    this.alignment = 0;
                    this.indentation.indentLeft -= paragraph.getIndentationLeft();
                    this.indentation.indentRight -= paragraph.getIndentationRight();
                    this.carriageReturn();
                    --this.leadingCount;
                    if (!PdfDocument.isTagged(this.writer)) break;
                    this.flushLines();
                    this.text.closeMCBlock(paragraph);
                    break;
                }
                case 13: 
                case 16: {
                    boolean hasTitle;
                    Section section = (Section)element;
                    PdfPageEvent pageEvent = this.writer.getPageEvent();
                    boolean bl = hasTitle = section.isNotAddedYet() && section.getTitle() != null;
                    if (section.isTriggerNewPage()) {
                        this.newPage();
                    }
                    if (hasTitle) {
                        float fith = this.indentTop() - this.currentHeight;
                        int rotation = this.pageSize.getRotation();
                        if (rotation == 90 || rotation == 180) {
                            fith = this.pageSize.getHeight() - fith;
                        }
                        PdfDestination destination = new PdfDestination(2, fith);
                        while (true) {
                            if (this.currentOutline.level() < section.getDepth()) {
                                PdfOutline outline;
                                this.currentOutline = outline = new PdfOutline(this.currentOutline, destination, section.getBookmarkTitle(), section.isBookmarkOpen());
                                break;
                            }
                            this.currentOutline = this.currentOutline.parent();
                        }
                    }
                    this.carriageReturn();
                    this.indentation.sectionIndentLeft += section.getIndentationLeft();
                    this.indentation.sectionIndentRight += section.getIndentationRight();
                    if (section.isNotAddedYet() && pageEvent != null) {
                        if (element.type() == 16) {
                            pageEvent.onChapter(this.writer, this, this.indentTop() - this.currentHeight, section.getTitle());
                        } else {
                            pageEvent.onSection(this.writer, this, this.indentTop() - this.currentHeight, section.getDepth(), section.getTitle());
                        }
                    }
                    if (hasTitle) {
                        this.isSectionTitle = true;
                        this.add(section.getTitle());
                        this.isSectionTitle = false;
                    }
                    this.indentation.sectionIndentLeft += section.getIndentation();
                    element.process(this);
                    this.flushLines();
                    this.indentation.sectionIndentLeft -= section.getIndentationLeft() + section.getIndentation();
                    this.indentation.sectionIndentRight -= section.getIndentationRight();
                    if (!section.isComplete() || pageEvent == null) break;
                    if (element.type() == 16) {
                        pageEvent.onChapterEnd(this.writer, this, this.indentTop() - this.currentHeight);
                        break;
                    }
                    pageEvent.onSectionEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    break;
                }
                case 14: {
                    List list = (List)element;
                    if (PdfDocument.isTagged(this.writer)) {
                        this.flushLines();
                        this.text.openMCBlock(list);
                    }
                    if (list.isAlignindent()) {
                        list.normalizeIndentation();
                    }
                    this.indentation.listIndentLeft += list.getIndentationLeft();
                    this.indentation.indentRight += list.getIndentationRight();
                    element.process(this);
                    this.indentation.listIndentLeft -= list.getIndentationLeft();
                    this.indentation.indentRight -= list.getIndentationRight();
                    this.carriageReturn();
                    if (!PdfDocument.isTagged(this.writer)) break;
                    this.flushLines();
                    this.text.closeMCBlock(list);
                    break;
                }
                case 15: {
                    ++this.leadingCount;
                    ListItem listItem = (ListItem)element;
                    if (PdfDocument.isTagged(this.writer)) {
                        this.flushLines();
                        this.text.openMCBlock(listItem);
                    }
                    this.addSpacing(listItem.getSpacingBefore(), this.leading, listItem.getFont());
                    this.alignment = listItem.getAlignment();
                    this.indentation.listIndentLeft += listItem.getIndentationLeft();
                    this.indentation.indentRight += listItem.getIndentationRight();
                    this.leading = listItem.getTotalLeading();
                    this.carriageReturn();
                    this.line.setListItem(listItem);
                    element.process(this);
                    this.addSpacing(listItem.getSpacingAfter(), listItem.getTotalLeading(), listItem.getFont());
                    if (this.line.hasToBeJustified()) {
                        this.line.resetAlignment();
                    }
                    this.carriageReturn();
                    this.indentation.listIndentLeft -= listItem.getIndentationLeft();
                    this.indentation.indentRight -= listItem.getIndentationRight();
                    --this.leadingCount;
                    if (!PdfDocument.isTagged(this.writer)) break;
                    this.flushLines();
                    this.text.closeMCBlock(listItem.getListBody());
                    this.text.closeMCBlock(listItem);
                    break;
                }
                case 30: {
                    Rectangle rectangle = (Rectangle)element;
                    this.graphics.rectangle(rectangle);
                    this.pageEmpty = false;
                    break;
                }
                case 23: {
                    PdfPTable ptable = (PdfPTable)element;
                    if (ptable.size() <= ptable.getHeaderRows()) break;
                    this.ensureNewLine();
                    this.flushLines();
                    this.addPTable(ptable);
                    this.pageEmpty = false;
                    this.newLine();
                    break;
                }
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    this.add((Image)element);
                    break;
                }
                case 55: {
                    DrawInterface zh = (DrawInterface)((Object)element);
                    zh.draw(this.graphics, this.indentLeft(), this.indentBottom(), this.indentRight(), this.indentTop(), this.indentTop() - this.currentHeight - (this.leadingCount > 0 ? this.leading : 0.0f));
                    this.pageEmpty = false;
                    break;
                }
                case 50: {
                    MarkedObject mo;
                    if (element instanceof MarkedSection && (mo = ((MarkedSection)element).getTitle()) != null) {
                        mo.process(this);
                    }
                    mo = (MarkedObject)element;
                    mo.process(this);
                    break;
                }
                case 666: {
                    if (this.writer == null) break;
                    ((WriterOperation)((Object)element)).write(this.writer, this);
                    break;
                }
                case 37: {
                    this.ensureNewLine();
                    this.flushLines();
                    this.addDiv((PdfDiv)element);
                    this.pageEmpty = false;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.lastElementType = element.type();
            return true;
        }
        catch (Exception e) {
            throw new DocumentException(e);
        }
    }

    @Override
    public void open() {
        if (!this.open) {
            super.open();
            this.writer.open();
            this.currentOutline = this.rootOutline = new PdfOutline(this.writer);
        }
        try {
            this.initPage();
            if (PdfDocument.isTagged(this.writer)) {
                this.openMCDocument = true;
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    @Override
    public void close() {
        if (this.close) {
            return;
        }
        try {
            if (PdfDocument.isTagged(this.writer)) {
                this.flushFloatingElements();
                this.flushLines();
                this.writer.getDirectContent().closeMCBlock(this);
                this.writer.flushTaggedObjects();
            }
            boolean wasImage = this.imageWait != null;
            this.newPage();
            if (this.imageWait != null || wasImage) {
                this.newPage();
            }
            if (this.annotationsImp.hasUnusedAnnotations()) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("not.all.annotations.could.be.added.to.the.document.the.document.doesn.t.have.enough.pages", new Object[0]));
            }
            PdfPageEvent pageEvent = this.writer.getPageEvent();
            if (pageEvent != null) {
                pageEvent.onCloseDocument(this.writer, this);
            }
            super.close();
            this.writer.addLocalDestinations(this.localDestinations);
            this.calculateOutlineCount();
            this.writeOutlines();
        }
        catch (Exception e) {
            throw ExceptionConverter.convertException(e);
        }
        this.writer.close();
    }

    public void setXmpMetadata(byte[] xmpMetadata) throws IOException {
        PdfStream xmp = new PdfStream(xmpMetadata);
        xmp.put(PdfName.TYPE, PdfName.METADATA);
        xmp.put(PdfName.SUBTYPE, PdfName.XML);
        PdfEncryption crypto = this.writer.getEncryption();
        if (crypto != null && !crypto.isMetadataEncrypted()) {
            PdfArray ar = new PdfArray();
            ar.add(PdfName.CRYPT);
            xmp.put(PdfName.FILTER, ar);
        }
        this.writer.addPageDictEntry(PdfName.METADATA, this.writer.addToBody(xmp).getIndirectReference());
    }

    @Override
    public boolean newPage() {
        try {
            this.flushFloatingElements();
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        this.lastElementType = -1;
        if (this.isPageEmpty()) {
            this.setNewPageSizeAndMargins();
            return false;
        }
        if (!this.open || this.close) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("the.document.is.not.open", new Object[0]));
        }
        PdfPageEvent pageEvent = this.writer.getPageEvent();
        if (pageEvent != null) {
            pageEvent.onEndPage(this.writer, this);
        }
        super.newPage();
        this.indentation.imageIndentLeft = 0.0f;
        this.indentation.imageIndentRight = 0.0f;
        try {
            PdfArray array;
            this.flushLines();
            int rotation = this.pageSize.getRotation();
            if (this.writer.isPdfIso()) {
                if (this.thisBoxSize.containsKey("art") && this.thisBoxSize.containsKey("trim")) {
                    throw new PdfXConformanceException(MessageLocalization.getComposedMessage("only.one.of.artbox.or.trimbox.can.exist.in.the.page", new Object[0]));
                }
                if (!this.thisBoxSize.containsKey("art") && !this.thisBoxSize.containsKey("trim")) {
                    if (this.thisBoxSize.containsKey("crop")) {
                        this.thisBoxSize.put("trim", this.thisBoxSize.get("crop"));
                    } else {
                        this.thisBoxSize.put("trim", new PdfRectangle(this.pageSize, this.pageSize.getRotation()));
                    }
                }
            }
            this.pageResources.addDefaultColorDiff(this.writer.getDefaultColorspace());
            if (this.writer.isRgbTransparencyBlending()) {
                PdfDictionary dcs = new PdfDictionary();
                dcs.put(PdfName.CS, PdfName.DEVICERGB);
                this.pageResources.addDefaultColorDiff(dcs);
            }
            PdfDictionary resources = this.pageResources.getResources();
            PdfPage page = new PdfPage(new PdfRectangle(this.pageSize, rotation), this.thisBoxSize, resources, rotation);
            if (PdfDocument.isTagged(this.writer)) {
                page.put(PdfName.TABS, PdfName.S);
            } else {
                page.put(PdfName.TABS, this.writer.getTabs());
            }
            page.putAll(this.writer.getPageDictEntries());
            this.writer.resetPageDictEntries();
            if (this.pageAA != null) {
                page.put(PdfName.AA, this.writer.addToBody(this.pageAA).getIndirectReference());
                this.pageAA = null;
            }
            if (this.annotationsImp.hasUnusedAnnotations() && (array = this.annotationsImp.rotateAnnotations(this.writer, this.pageSize)).size() != 0) {
                page.put(PdfName.ANNOTS, array);
            }
            if (PdfDocument.isTagged(this.writer)) {
                page.put(PdfName.STRUCTPARENTS, new PdfNumber(this.writer.getCurrentPageNumber() - 1));
            }
            if (this.text.size() > this.textEmptySize || PdfDocument.isTagged(this.writer)) {
                this.text.endText();
            } else {
                this.text = null;
            }
            ArrayList<IAccessibleElement> mcBlocks = null;
            if (PdfDocument.isTagged(this.writer)) {
                mcBlocks = this.writer.getDirectContent().saveMCBlocks();
            }
            this.writer.add(page, new PdfContents(this.writer.getDirectContentUnder(), this.graphics, !PdfDocument.isTagged(this.writer) ? this.text : null, this.writer.getDirectContent(), this.pageSize));
            this.initPage();
            if (PdfDocument.isTagged(this.writer)) {
                this.writer.getDirectContentUnder().restoreMCBlocks(mcBlocks);
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
        return true;
    }

    @Override
    public boolean setPageSize(Rectangle pageSize) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextPageSize = new Rectangle(pageSize);
        return true;
    }

    @Override
    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextMarginLeft = marginLeft;
        this.nextMarginRight = marginRight;
        this.nextMarginTop = marginTop;
        this.nextMarginBottom = marginBottom;
        return true;
    }

    @Override
    public boolean setMarginMirroring(boolean MarginMirroring) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        return super.setMarginMirroring(MarginMirroring);
    }

    @Override
    public boolean setMarginMirroringTopBottom(boolean MarginMirroringTopBottom) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        return super.setMarginMirroringTopBottom(MarginMirroringTopBottom);
    }

    @Override
    public void setPageCount(int pageN) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setPageCount(pageN);
    }

    @Override
    public void resetPageCount() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetPageCount();
    }

    protected void initPage() throws DocumentException {
        ++this.pageN;
        this.annotationsImp.resetAnnotations();
        this.pageResources = new PageResources();
        this.writer.resetContent();
        if (PdfDocument.isTagged(this.writer)) {
            this.writer.getDirectContent().duplicatedFrom = this.graphics = this.writer.getDirectContentUnder().getDuplicate();
        } else {
            this.graphics = new PdfContentByte(this.writer);
        }
        this.markPoint = 0;
        this.setNewPageSizeAndMargins();
        this.imageEnd = -1.0f;
        this.indentation.imageIndentRight = 0.0f;
        this.indentation.imageIndentLeft = 0.0f;
        this.indentation.indentBottom = 0.0f;
        this.indentation.indentTop = 0.0f;
        this.currentHeight = 0.0f;
        this.thisBoxSize = new HashMap<String, PdfRectangle>(this.boxSize);
        if (this.pageSize.getBackgroundColor() != null || this.pageSize.hasBorders() || this.pageSize.getBorderColor() != null) {
            this.add(this.pageSize);
        }
        float oldleading = this.leading;
        int oldAlignment = this.alignment;
        this.pageEmpty = true;
        try {
            if (this.imageWait != null) {
                this.add(this.imageWait);
                this.imageWait = null;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        this.leading = oldleading;
        this.alignment = oldAlignment;
        this.carriageReturn();
        PdfPageEvent pageEvent = this.writer.getPageEvent();
        if (pageEvent != null) {
            if (this.firstPageEvent) {
                pageEvent.onOpenDocument(this.writer, this);
            }
            pageEvent.onStartPage(this.writer, this);
        }
        this.firstPageEvent = false;
    }

    protected void newLine() throws DocumentException {
        this.lastElementType = -1;
        this.carriageReturn();
        if (this.lines != null && !this.lines.isEmpty()) {
            this.lines.add(this.line);
            this.currentHeight += this.line.height();
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    protected void carriageReturn() {
        if (this.lines == null) {
            this.lines = new ArrayList();
        }
        if (this.line != null && this.line.size() > 0) {
            if (this.currentHeight + this.line.height() + this.leading > this.indentTop() - this.indentBottom()) {
                PdfLine overflowLine = this.line;
                this.line = null;
                this.newPage();
                this.line = overflowLine;
                overflowLine.left = this.indentLeft();
            }
            this.currentHeight += this.line.height();
            this.lines.add(this.line);
            this.pageEmpty = false;
        }
        if (this.imageEnd > -1.0f && this.currentHeight > this.imageEnd) {
            this.imageEnd = -1.0f;
            this.indentation.imageIndentRight = 0.0f;
            this.indentation.imageIndentLeft = 0.0f;
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    public float getVerticalPosition(boolean ensureNewLine) {
        if (ensureNewLine) {
            this.ensureNewLine();
        }
        return this.top() - this.currentHeight - this.indentation.indentTop;
    }

    protected void ensureNewLine() {
        try {
            if (this.lastElementType == 11 || this.lastElementType == 10) {
                this.newLine();
                this.flushLines();
            }
        }
        catch (DocumentException ex) {
            throw new ExceptionConverter(ex);
        }
    }

    protected float flushLines() throws DocumentException {
        if (this.lines == null) {
            return 0.0f;
        }
        if (this.line != null && this.line.size() > 0) {
            this.lines.add(this.line);
            this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
        }
        if (this.lines.isEmpty()) {
            return 0.0f;
        }
        Object[] currentValues = new Object[2];
        PdfFont currentFont = null;
        float displacement = 0.0f;
        Float lastBaseFactor = new Float(0.0f);
        currentValues[1] = lastBaseFactor;
        for (PdfLine l : this.lines) {
            float moveTextX = l.indentLeft() - this.indentLeft() + this.indentation.indentLeft + this.indentation.listIndentLeft + this.indentation.sectionIndentLeft;
            this.text.moveText(moveTextX, -l.height());
            if (l.listSymbol() != null) {
                ListLabel lbl = null;
                Chunk symbol = l.listSymbol();
                if (PdfDocument.isTagged(this.writer)) {
                    lbl = l.listItem().getListLabel();
                    this.graphics.openMCBlock(lbl);
                    symbol = new Chunk(symbol);
                    if (!lbl.getTagLabelContent()) {
                        symbol.setRole(null);
                    }
                }
                ColumnText.showTextAligned(this.graphics, 0, new Phrase(symbol), this.text.getXTLM() - l.listIndent(), this.text.getYTLM(), 0.0f);
                if (lbl != null) {
                    this.graphics.closeMCBlock(lbl);
                }
            }
            currentValues[0] = currentFont;
            if (PdfDocument.isTagged(this.writer) && l.listItem() != null) {
                this.text.openMCBlock(l.listItem().getListBody());
            }
            this.writeLineToContent(l, this.text, this.graphics, currentValues, this.writer.getSpaceCharRatio());
            currentFont = (PdfFont)currentValues[0];
            displacement += l.height();
            this.text.moveText(-moveTextX, 0.0f);
        }
        this.lines = new ArrayList();
        return displacement;
    }

    float writeLineToContent(PdfLine line, PdfContentByte text, PdfContentByte graphics, Object[] currentValues, float ratio) throws DocumentException {
        float xMarker;
        PdfFont currentFont = (PdfFont)currentValues[0];
        float lastBaseFactor = ((Float)currentValues[1]).floatValue();
        float hangingCorrection = 0.0f;
        float hScale = 1.0f;
        float lastHScale = Float.NaN;
        float baseWordSpacing = 0.0f;
        float baseCharacterSpacing = 0.0f;
        float glueWidth = 0.0f;
        float lastX = text.getXTLM() + line.getOriginalWidth();
        int numberOfSpaces = line.numberOfSpaces();
        int lineLen = line.getLineLengthUtf32();
        boolean isJustified = line.hasToBeJustified() && (numberOfSpaces != 0 || lineLen > 1);
        int separatorCount = line.getSeparatorCount();
        if (separatorCount > 0) {
            glueWidth = line.widthLeft() / (float)separatorCount;
        } else if (isJustified && separatorCount == 0) {
            if (line.isNewlineSplit() && line.widthLeft() >= lastBaseFactor * (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f)) {
                if (line.isRTL()) {
                    text.moveText(line.widthLeft() - lastBaseFactor * (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f), 0.0f);
                }
                baseWordSpacing = ratio * lastBaseFactor;
                baseCharacterSpacing = lastBaseFactor;
            } else {
                char c;
                String s;
                float width = line.widthLeft();
                PdfChunk last = line.getChunk(line.size() - 1);
                if (last != null && (s = last.toString()).length() > 0 && hangingPunctuation.indexOf(c = s.charAt(s.length() - 1)) >= 0) {
                    float oldWidth = width;
                    hangingCorrection = (width += last.font().width(c) * 0.4f) - oldWidth;
                }
                float baseFactor = width / (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f);
                baseWordSpacing = ratio * baseFactor;
                baseCharacterSpacing = baseFactor;
                lastBaseFactor = baseFactor;
            }
        } else if (line.alignment == 0 || line.alignment == -1) {
            lastX -= line.widthLeft();
        }
        int lastChunkStroke = line.getLastStrokeChunk();
        int chunkStrokeIdx = 0;
        float baseXMarker = xMarker = text.getXTLM();
        float yMarker = text.getYTLM();
        boolean adjustMatrix = false;
        float tabPosition = 0.0f;
        Iterator<PdfChunk> j = line.iterator();
        while (j.hasNext()) {
            PdfChunk chunk = j.next();
            if (PdfDocument.isTagged(this.writer) && chunk.accessibleElement != null) {
                text.openMCBlock(chunk.accessibleElement);
            }
            BaseColor color = chunk.color();
            float fontSize = chunk.font().size();
            float ascender = chunk.font().getFont().getFontDescriptor(1, fontSize);
            float descender = chunk.font().getFont().getFontDescriptor(3, fontSize);
            hScale = 1.0f;
            if (chunkStrokeIdx <= lastChunkStroke) {
                float width = isJustified ? chunk.getWidthCorrected(baseCharacterSpacing, baseWordSpacing) : chunk.width();
                if (chunk.isStroked()) {
                    DrawInterface di;
                    PdfChunk nextChunk = line.getChunk(chunkStrokeIdx + 1);
                    if (chunk.isSeparator()) {
                        width = glueWidth;
                        Object[] sep = (Object[])chunk.getAttribute("SEPARATOR");
                        di = (DrawInterface)sep[0];
                        Boolean vertical = (Boolean)sep[1];
                        if (vertical.booleanValue()) {
                            di.draw(graphics, baseXMarker, yMarker + descender, baseXMarker + line.getOriginalWidth(), ascender - descender, yMarker);
                        } else {
                            di.draw(graphics, xMarker, yMarker + descender, xMarker + width, ascender - descender, yMarker);
                        }
                    }
                    if (chunk.isTab()) {
                        Object[] tab = (Object[])chunk.getAttribute("TAB");
                        di = (DrawInterface)tab[0];
                        tabPosition = ((Float)tab[1]).floatValue() + ((Float)tab[3]).floatValue();
                        if (tabPosition > xMarker) {
                            di.draw(graphics, xMarker, yMarker + descender, tabPosition, ascender - descender, yMarker);
                        }
                        float tmp = xMarker;
                        xMarker = tabPosition;
                        tabPosition = tmp;
                    }
                    if (chunk.isAttribute("BACKGROUND")) {
                        boolean inText = graphics.getInText();
                        if (inText && PdfDocument.isTagged(this.writer)) {
                            graphics.endText();
                        }
                        float subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("BACKGROUND")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Object[] bgr = (Object[])chunk.getAttribute("BACKGROUND");
                        graphics.setColorFill((BaseColor)bgr[0]);
                        float[] extra = (float[])bgr[1];
                        graphics.rectangle(xMarker - extra[0], yMarker + descender - extra[1] + chunk.getTextRise(), width - subtract + extra[0] + extra[2], ascender - descender + extra[1] + extra[3]);
                        graphics.fill();
                        graphics.setGrayFill(0.0f);
                        if (inText && PdfDocument.isTagged(this.writer)) {
                            graphics.beginText(true);
                        }
                    }
                    if (chunk.isAttribute("UNDERLINE")) {
                        boolean inText = graphics.getInText();
                        if (inText && PdfDocument.isTagged(this.writer)) {
                            graphics.endText();
                        }
                        float subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("UNDERLINE")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Object[][] unders = (Object[][])chunk.getAttribute("UNDERLINE");
                        BaseColor scolor = null;
                        int k = 0;
                        while (k < unders.length) {
                            Object[] obj = unders[k];
                            scolor = (BaseColor)obj[0];
                            float[] ps = (float[])obj[1];
                            if (scolor == null) {
                                scolor = color;
                            }
                            if (scolor != null) {
                                graphics.setColorStroke(scolor);
                            }
                            graphics.setLineWidth(ps[0] + fontSize * ps[1]);
                            float shift = ps[2] + fontSize * ps[3];
                            int cap2 = (int)ps[4];
                            if (cap2 != 0) {
                                graphics.setLineCap(cap2);
                            }
                            graphics.moveTo(xMarker, yMarker + shift);
                            graphics.lineTo(xMarker + width - subtract, yMarker + shift);
                            graphics.stroke();
                            if (scolor != null) {
                                graphics.resetGrayStroke();
                            }
                            if (cap2 != 0) {
                                graphics.setLineCap(0);
                            }
                            ++k;
                        }
                        graphics.setLineWidth(1.0f);
                        if (inText && PdfDocument.isTagged(this.writer)) {
                            graphics.beginText(true);
                        }
                    }
                    if (chunk.isAttribute("ACTION")) {
                        PdfStructureElement strucElem;
                        float subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("ACTION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        PdfAnnotation annot = null;
                        annot = chunk.isImage() ? new PdfAnnotation(this.writer, xMarker, yMarker + chunk.getImageOffsetY(), xMarker + width - subtract, yMarker + chunk.getImageHeight() + chunk.getImageOffsetY(), (PdfAction)chunk.getAttribute("ACTION")) : new PdfAnnotation(this.writer, xMarker, yMarker + descender + chunk.getTextRise(), xMarker + width - subtract, yMarker + ascender + chunk.getTextRise(), (PdfAction)chunk.getAttribute("ACTION"));
                        text.addAnnotation(annot);
                        if (PdfDocument.isTagged(this.writer) && chunk.accessibleElement != null && (strucElem = this.structElements.get(chunk.accessibleElement.getId())) != null) {
                            PdfArray kArray = strucElem.getAsArray(PdfName.K);
                            if (kArray == null) {
                                kArray = new PdfArray();
                                PdfObject k = strucElem.get(PdfName.K);
                                if (k != null) {
                                    kArray.add(k);
                                }
                                strucElem.put(PdfName.K, kArray);
                            }
                            PdfDictionary dict = new PdfDictionary();
                            dict.put(PdfName.TYPE, PdfName.OBJR);
                            dict.put(PdfName.OBJ, annot.getIndirectReference());
                            kArray.add(dict);
                        }
                    }
                    if (chunk.isAttribute("REMOTEGOTO")) {
                        float subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("REMOTEGOTO")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Object[] obj = (Object[])chunk.getAttribute("REMOTEGOTO");
                        String filename = (String)obj[0];
                        if (obj[1] instanceof String) {
                            this.remoteGoto(filename, (String)obj[1], xMarker, yMarker + descender + chunk.getTextRise(), xMarker + width - subtract, yMarker + ascender + chunk.getTextRise());
                        } else {
                            this.remoteGoto(filename, (Integer)obj[1], xMarker, yMarker + descender + chunk.getTextRise(), xMarker + width - subtract, yMarker + ascender + chunk.getTextRise());
                        }
                    }
                    if (chunk.isAttribute("LOCALGOTO")) {
                        float subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("LOCALGOTO")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        this.localGoto((String)chunk.getAttribute("LOCALGOTO"), xMarker, yMarker, xMarker + width - subtract, yMarker + fontSize);
                    }
                    if (chunk.isAttribute("LOCALDESTINATION")) {
                        this.localDestination((String)chunk.getAttribute("LOCALDESTINATION"), new PdfDestination(0, xMarker, yMarker + fontSize, 0.0f));
                    }
                    if (chunk.isAttribute("GENERICTAG")) {
                        float subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("GENERICTAG")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Rectangle rect = new Rectangle(xMarker, yMarker, xMarker + width - subtract, yMarker + fontSize);
                        PdfPageEvent pev = this.writer.getPageEvent();
                        if (pev != null) {
                            pev.onGenericTag(this.writer, this, rect, (String)chunk.getAttribute("GENERICTAG"));
                        }
                    }
                    if (chunk.isAttribute("PDFANNOTATION")) {
                        float subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("PDFANNOTATION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        PdfAnnotation annot = PdfFormField.shallowDuplicate((PdfAnnotation)chunk.getAttribute("PDFANNOTATION"));
                        annot.put(PdfName.RECT, new PdfRectangle(xMarker, yMarker + descender, xMarker + width - subtract, yMarker + ascender));
                        text.addAnnotation(annot);
                    }
                    float[] params = (float[])chunk.getAttribute("SKEW");
                    Float hs = (Float)chunk.getAttribute("HSCALE");
                    if (params != null || hs != null) {
                        float b = 0.0f;
                        float c = 0.0f;
                        if (params != null) {
                            b = params[0];
                            c = params[1];
                        }
                        if (hs != null) {
                            hScale = hs.floatValue();
                        }
                        text.setTextMatrix(hScale, b, c, 1.0f, xMarker, yMarker);
                    }
                    if (chunk.isAttribute("CHAR_SPACING")) {
                        Float cs = (Float)chunk.getAttribute("CHAR_SPACING");
                        text.setCharacterSpacing(cs.floatValue());
                    }
                    if (chunk.isImage()) {
                        Image image = chunk.getImage();
                        float[] matrix = image.matrix(chunk.getImageScalePercentage());
                        matrix[4] = xMarker + chunk.getImageOffsetX() - matrix[4];
                        matrix[5] = yMarker + chunk.getImageOffsetY() - matrix[5];
                        graphics.addImage(image, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
                        text.moveText(xMarker + lastBaseFactor + chunk.getImageWidth() - text.getXTLM(), 0.0f);
                    }
                }
                if (!chunk.isTabSpace()) {
                    xMarker += width;
                }
                ++chunkStrokeIdx;
            }
            if (chunk.font().compareTo(currentFont) != 0) {
                currentFont = chunk.font();
                text.setFontAndSize(currentFont.getFont(), currentFont.size());
            }
            float rise = 0.0f;
            Object[] textRender = (Object[])chunk.getAttribute("TEXTRENDERMODE");
            int tr = 0;
            float strokeWidth = 1.0f;
            BaseColor strokeColor = null;
            Float fr = (Float)chunk.getAttribute("SUBSUPSCRIPT");
            if (textRender != null) {
                tr = (Integer)textRender[0] & 3;
                if (tr != 0) {
                    text.setTextRenderingMode(tr);
                }
                if (tr == 1 || tr == 2) {
                    strokeWidth = ((Float)textRender[1]).floatValue();
                    if (strokeWidth != 1.0f) {
                        text.setLineWidth(strokeWidth);
                    }
                    if ((strokeColor = (BaseColor)textRender[2]) == null) {
                        strokeColor = color;
                    }
                    if (strokeColor != null) {
                        text.setColorStroke(strokeColor);
                    }
                }
            }
            if (fr != null) {
                rise = fr.floatValue();
            }
            if (color != null) {
                text.setColorFill(color);
            }
            if (rise != 0.0f) {
                text.setTextRise(rise);
            }
            if (chunk.isImage()) {
                adjustMatrix = true;
            } else if (chunk.isHorizontalSeparator()) {
                PdfTextArray array = new PdfTextArray();
                array.add(-glueWidth * 1000.0f / chunk.font.size() / hScale);
                text.showText(array);
            } else if (chunk.isTab()) {
                PdfTextArray array = new PdfTextArray();
                array.add((tabPosition - xMarker) * 1000.0f / chunk.font.size() / hScale);
                text.showText(array);
            } else if (chunk.isTabSpace()) {
                Float module = (Float)chunk.getAttribute("TABSPACE");
                float increment = module.floatValue() - (xMarker - text.getXTLM()) % module.floatValue();
                xMarker += increment;
                PdfTextArray array = new PdfTextArray();
                array.add(-(increment * 1000.0f / chunk.font.size() / hScale));
                text.showText(array);
            } else if (isJustified && numberOfSpaces > 0 && chunk.isSpecialEncoding()) {
                String s;
                int idx;
                if (hScale != lastHScale) {
                    lastHScale = hScale;
                    text.setWordSpacing(baseWordSpacing / hScale);
                    text.setCharacterSpacing(baseCharacterSpacing / hScale + text.getCharacterSpacing());
                }
                if ((idx = (s = chunk.toString()).indexOf(32)) < 0) {
                    text.showText(s);
                } else {
                    float spaceCorrection = -baseWordSpacing * 1000.0f / chunk.font.size() / hScale;
                    PdfTextArray textArray = new PdfTextArray(s.substring(0, idx));
                    int lastIdx = idx;
                    while ((idx = s.indexOf(32, lastIdx + 1)) >= 0) {
                        textArray.add(spaceCorrection);
                        textArray.add(s.substring(lastIdx, idx));
                        lastIdx = idx;
                    }
                    textArray.add(spaceCorrection);
                    textArray.add(s.substring(lastIdx));
                    text.showText(textArray);
                }
            } else {
                if (isJustified && hScale != lastHScale) {
                    lastHScale = hScale;
                    text.setWordSpacing(baseWordSpacing / hScale);
                    text.setCharacterSpacing(baseCharacterSpacing / hScale + text.getCharacterSpacing());
                }
                text.showText(chunk.toString());
            }
            if (rise != 0.0f) {
                text.setTextRise(0.0f);
            }
            if (color != null) {
                text.resetRGBColorFill();
            }
            if (tr != 0) {
                text.setTextRenderingMode(0);
            }
            if (strokeColor != null) {
                text.resetRGBColorStroke();
            }
            if (strokeWidth != 1.0f) {
                text.setLineWidth(1.0f);
            }
            if (chunk.isAttribute("SKEW") || chunk.isAttribute("HSCALE")) {
                adjustMatrix = true;
                text.setTextMatrix(xMarker, yMarker);
            }
            if (chunk.isAttribute("CHAR_SPACING")) {
                text.setCharacterSpacing(baseCharacterSpacing);
            }
            if (!PdfDocument.isTagged(this.writer) || chunk.accessibleElement == null) continue;
            text.closeMCBlock(chunk.accessibleElement);
        }
        if (isJustified) {
            text.setWordSpacing(0.0f);
            text.setCharacterSpacing(0.0f);
            if (line.isNewlineSplit()) {
                lastBaseFactor = 0.0f;
            }
        }
        if (adjustMatrix) {
            text.moveText(baseXMarker - text.getXTLM(), 0.0f);
        }
        currentValues[0] = currentFont;
        currentValues[1] = new Float(lastBaseFactor);
        return lastX;
    }

    protected float indentLeft() {
        return this.left(this.indentation.indentLeft + this.indentation.listIndentLeft + this.indentation.imageIndentLeft + this.indentation.sectionIndentLeft);
    }

    protected float indentRight() {
        return this.right(this.indentation.indentRight + this.indentation.sectionIndentRight + this.indentation.imageIndentRight);
    }

    protected float indentTop() {
        return this.top(this.indentation.indentTop);
    }

    float indentBottom() {
        return this.bottom(this.indentation.indentBottom);
    }

    protected void addSpacing(float extraspace, float oldleading, Font f) {
        if (extraspace == 0.0f) {
            return;
        }
        if (this.pageEmpty) {
            return;
        }
        if (this.currentHeight + this.line.height() + this.leading > this.indentTop() - this.indentBottom()) {
            return;
        }
        this.leading = extraspace;
        this.carriageReturn();
        if (f.isUnderlined() || f.isStrikethru()) {
            f = new Font(f);
            int style = f.getStyle();
            style &= 0xFFFFFFFB;
            f.setStyle(style &= 0xFFFFFFF7);
        }
        Chunk space = new Chunk(" ", f);
        space.process(this);
        this.carriageReturn();
        this.leading = oldleading;
    }

    PdfInfo getInfo() {
        return this.info;
    }

    PdfCatalog getCatalog(PdfIndirectReference pages) {
        PdfCatalog catalog = new PdfCatalog(pages, this.writer);
        if (this.rootOutline.getKids().size() > 0) {
            catalog.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            catalog.put(PdfName.OUTLINES, this.rootOutline.indirectReference());
        }
        this.writer.getPdfVersion().addToCatalog(catalog);
        this.viewerPreferences.addToCatalog(catalog);
        if (this.pageLabels != null) {
            catalog.put(PdfName.PAGELABELS, this.pageLabels.getDictionary(this.writer));
        }
        catalog.addNames(this.localDestinations, this.getDocumentLevelJS(), this.documentFileAttachment, this.writer);
        if (this.openActionName != null) {
            PdfAction action = this.getLocalGotoAction(this.openActionName);
            catalog.setOpenAction(action);
        } else if (this.openActionAction != null) {
            catalog.setOpenAction(this.openActionAction);
        }
        if (this.additionalActions != null) {
            catalog.setAdditionalActions(this.additionalActions);
        }
        if (this.collection != null) {
            catalog.put(PdfName.COLLECTION, this.collection);
        }
        if (this.annotationsImp.hasValidAcroForm()) {
            try {
                catalog.put(PdfName.ACROFORM, this.writer.addToBody(this.annotationsImp.getAcroForm()).getIndirectReference());
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }
        if (this.language != null) {
            catalog.put(PdfName.LANG, this.language);
        }
        return catalog;
    }

    void addOutline(PdfOutline outline, String name) {
        this.localDestination(name, outline.getPdfDestination());
    }

    public PdfOutline getRootOutline() {
        return this.rootOutline;
    }

    void calculateOutlineCount() {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.traverseOutlineCount(this.rootOutline);
    }

    void traverseOutlineCount(PdfOutline outline) {
        ArrayList<PdfOutline> kids = outline.getKids();
        PdfOutline parent = outline.parent();
        if (kids.isEmpty()) {
            if (parent != null) {
                parent.setCount(parent.getCount() + 1);
            }
        } else {
            int k = 0;
            while (k < kids.size()) {
                this.traverseOutlineCount(kids.get(k));
                ++k;
            }
            if (parent != null) {
                if (outline.isOpen()) {
                    parent.setCount(outline.getCount() + parent.getCount() + 1);
                } else {
                    parent.setCount(parent.getCount() + 1);
                    outline.setCount(-outline.getCount());
                }
            }
        }
    }

    void writeOutlines() throws IOException {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.outlineTree(this.rootOutline);
        this.writer.addToBody((PdfObject)this.rootOutline, this.rootOutline.indirectReference());
    }

    void outlineTree(PdfOutline outline) throws IOException {
        outline.setIndirectReference(this.writer.getPdfIndirectReference());
        if (outline.parent() != null) {
            outline.put(PdfName.PARENT, outline.parent().indirectReference());
        }
        ArrayList<PdfOutline> kids = outline.getKids();
        int size = kids.size();
        int k = 0;
        while (k < size) {
            this.outlineTree(kids.get(k));
            ++k;
        }
        k = 0;
        while (k < size) {
            if (k > 0) {
                kids.get(k).put(PdfName.PREV, kids.get(k - 1).indirectReference());
            }
            if (k < size - 1) {
                kids.get(k).put(PdfName.NEXT, kids.get(k + 1).indirectReference());
            }
            ++k;
        }
        if (size > 0) {
            outline.put(PdfName.FIRST, kids.get(0).indirectReference());
            outline.put(PdfName.LAST, kids.get(size - 1).indirectReference());
        }
        k = 0;
        while (k < size) {
            PdfOutline kid = kids.get(k);
            this.writer.addToBody((PdfObject)kid, kid.indirectReference());
            ++k;
        }
    }

    void setViewerPreferences(int preferences) {
        this.viewerPreferences.setViewerPreferences(preferences);
    }

    void addViewerPreference(PdfName key, PdfObject value) {
        this.viewerPreferences.addViewerPreference(key, value);
    }

    void setPageLabels(PdfPageLabels pageLabels) {
        this.pageLabels = pageLabels;
    }

    public PdfPageLabels getPageLabels() {
        return this.pageLabels;
    }

    void localGoto(String name, float llx, float lly, float urx, float ury) {
        PdfAction action = this.getLocalGotoAction(name);
        this.annotationsImp.addPlainAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, action));
    }

    void remoteGoto(String filename, String name, float llx, float lly, float urx, float ury) {
        this.annotationsImp.addPlainAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, new PdfAction(filename, name)));
    }

    void remoteGoto(String filename, int page, float llx, float lly, float urx, float ury) {
        this.addAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, new PdfAction(filename, page)));
    }

    void setAction(PdfAction action, float llx, float lly, float urx, float ury) {
        this.addAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, action));
    }

    PdfAction getLocalGotoAction(String name) {
        PdfAction action;
        Destination dest = this.localDestinations.get(name);
        if (dest == null) {
            dest = new Destination();
        }
        if (dest.action == null) {
            if (dest.reference == null) {
                dest.reference = this.writer.getPdfIndirectReference();
            }
            dest.action = action = new PdfAction(dest.reference);
            this.localDestinations.put(name, dest);
        } else {
            action = dest.action;
        }
        return action;
    }

    boolean localDestination(String name, PdfDestination destination) {
        Destination dest = this.localDestinations.get(name);
        if (dest == null) {
            dest = new Destination();
        }
        if (dest.destination != null) {
            return false;
        }
        dest.destination = destination;
        this.localDestinations.put(name, dest);
        if (!destination.hasPage()) {
            destination.addPage(this.writer.getCurrentPage());
        }
        return true;
    }

    void addJavaScript(PdfAction js) {
        if (js.get(PdfName.JS) == null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("only.javascript.actions.are.allowed", new Object[0]));
        }
        try {
            this.documentLevelJS.put(SIXTEEN_DIGITS.format(this.jsCounter++), this.writer.addToBody(js).getIndirectReference());
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    void addJavaScript(String name, PdfAction js) {
        if (js.get(PdfName.JS) == null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("only.javascript.actions.are.allowed", new Object[0]));
        }
        try {
            this.documentLevelJS.put(name, this.writer.addToBody(js).getIndirectReference());
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    HashMap<String, PdfObject> getDocumentLevelJS() {
        return this.documentLevelJS;
    }

    void addFileAttachment(String description, PdfFileSpecification fs) throws IOException {
        if (description == null) {
            PdfString desc = (PdfString)fs.get(PdfName.DESC);
            description = desc == null ? "" : PdfEncodings.convertToString(desc.getBytes(), null);
        }
        fs.addDescription(description, true);
        if (description.length() == 0) {
            description = "Unnamed";
        }
        String fn = PdfEncodings.convertToString(new PdfString(description, "UnicodeBig").getBytes(), null);
        int k = 0;
        while (this.documentFileAttachment.containsKey(fn)) {
            fn = PdfEncodings.convertToString(new PdfString(String.valueOf(description) + " " + ++k, "UnicodeBig").getBytes(), null);
        }
        this.documentFileAttachment.put(fn, fs.getReference());
    }

    HashMap<String, PdfObject> getDocumentFileAttachment() {
        return this.documentFileAttachment;
    }

    void setOpenAction(String name) {
        this.openActionName = name;
        this.openActionAction = null;
    }

    void setOpenAction(PdfAction action) {
        this.openActionAction = action;
        this.openActionName = null;
    }

    void addAdditionalAction(PdfName actionType, PdfAction action) {
        if (this.additionalActions == null) {
            this.additionalActions = new PdfDictionary();
        }
        if (action == null) {
            this.additionalActions.remove(actionType);
        } else {
            this.additionalActions.put(actionType, action);
        }
        if (this.additionalActions.size() == 0) {
            this.additionalActions = null;
        }
    }

    public void setCollection(PdfCollection collection) {
        this.collection = collection;
    }

    PdfAcroForm getAcroForm() {
        return this.annotationsImp.getAcroForm();
    }

    void setSigFlags(int f) {
        this.annotationsImp.setSigFlags(f);
    }

    void addCalculationOrder(PdfFormField formField) {
        this.annotationsImp.addCalculationOrder(formField);
    }

    void addAnnotation(PdfAnnotation annot) {
        this.pageEmpty = false;
        this.annotationsImp.addAnnotation(annot);
    }

    void setLanguage(String language) {
        this.language = new PdfString(language);
    }

    int getMarkPoint() {
        return this.markPoint;
    }

    void incMarkPoint() {
        ++this.markPoint;
    }

    void setCropBoxSize(Rectangle crop) {
        this.setBoxSize("crop", crop);
    }

    void setBoxSize(String boxName, Rectangle size) {
        if (size == null) {
            this.boxSize.remove(boxName);
        } else {
            this.boxSize.put(boxName, new PdfRectangle(size));
        }
    }

    protected void setNewPageSizeAndMargins() {
        this.pageSize = this.nextPageSize;
        if (this.marginMirroring && (this.getPageNumber() & 1) == 0) {
            this.marginRight = this.nextMarginLeft;
            this.marginLeft = this.nextMarginRight;
        } else {
            this.marginLeft = this.nextMarginLeft;
            this.marginRight = this.nextMarginRight;
        }
        if (this.marginMirroringTopBottom && (this.getPageNumber() & 1) == 0) {
            this.marginTop = this.nextMarginBottom;
            this.marginBottom = this.nextMarginTop;
        } else {
            this.marginTop = this.nextMarginTop;
            this.marginBottom = this.nextMarginBottom;
        }
        if (!PdfDocument.isTagged(this.writer)) {
            this.text = new PdfContentByte(this.writer);
            this.text.reset();
        } else {
            this.text = this.graphics;
        }
        this.text.beginText();
        this.text.moveText(this.left(), this.top());
        if (PdfDocument.isTagged(this.writer)) {
            this.textEmptySize = this.text.size();
        }
    }

    Rectangle getBoxSize(String boxName) {
        PdfRectangle r = this.thisBoxSize.get(boxName);
        if (r != null) {
            return r.getRectangle();
        }
        return null;
    }

    void setPageEmpty(boolean pageEmpty) {
        this.pageEmpty = pageEmpty;
    }

    boolean isPageEmpty() {
        if (PdfDocument.isTagged(this.writer)) {
            return this.writer == null || this.writer.getDirectContent().size(false) == 0 && this.writer.getDirectContentUnder().size(false) == 0 && this.text.size(false) - this.textEmptySize == 0 && (this.pageEmpty || this.writer.isPaused());
        }
        return this.writer == null || this.writer.getDirectContent().size() == 0 && this.writer.getDirectContentUnder().size() == 0 && (this.pageEmpty || this.writer.isPaused());
    }

    void setDuration(int seconds) {
        if (seconds > 0) {
            this.writer.addPageDictEntry(PdfName.DUR, new PdfNumber(seconds));
        }
    }

    void setTransition(PdfTransition transition) {
        this.writer.addPageDictEntry(PdfName.TRANS, transition.getTransitionDictionary());
    }

    void setPageAction(PdfName actionType, PdfAction action) {
        if (this.pageAA == null) {
            this.pageAA = new PdfDictionary();
        }
        this.pageAA.put(actionType, action);
    }

    void setThumbnail(Image image) throws PdfException, DocumentException {
        this.writer.addPageDictEntry(PdfName.THUMB, this.writer.getImageReference(this.writer.addDirectImageSimple(image)));
    }

    PageResources getPageResources() {
        return this.pageResources;
    }

    boolean isStrictImageSequence() {
        return this.strictImageSequence;
    }

    void setStrictImageSequence(boolean strictImageSequence) {
        this.strictImageSequence = strictImageSequence;
    }

    public void clearTextWrap() {
        float tmpHeight = this.imageEnd - this.currentHeight;
        if (this.line != null) {
            tmpHeight += this.line.height();
        }
        if (this.imageEnd > -1.0f && tmpHeight > 0.0f) {
            this.carriageReturn();
            this.currentHeight += tmpHeight;
        }
    }

    protected void add(Image image) throws PdfException, DocumentException {
        if (image.hasAbsoluteY()) {
            this.graphics.addImage(image);
            this.pageEmpty = false;
            return;
        }
        if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.getScaledHeight() < this.indentBottom()) {
            if (!this.strictImageSequence && this.imageWait == null) {
                this.imageWait = image;
                return;
            }
            this.newPage();
            if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.getScaledHeight() < this.indentBottom()) {
                this.imageWait = image;
                return;
            }
        }
        this.pageEmpty = false;
        if (image == this.imageWait) {
            this.imageWait = null;
        }
        boolean textwrap = (image.getAlignment() & 4) == 4 && (image.getAlignment() & 1) != 1;
        boolean underlying = (image.getAlignment() & 8) == 8;
        float diff = this.leading / 2.0f;
        if (textwrap) {
            diff += this.leading;
        }
        float lowerleft = this.indentTop() - this.currentHeight - image.getScaledHeight() - diff;
        float[] mt = image.matrix();
        float startPosition = this.indentLeft() - mt[4];
        if ((image.getAlignment() & 2) == 2) {
            startPosition = this.indentRight() - image.getScaledWidth() - mt[4];
        }
        if ((image.getAlignment() & 1) == 1) {
            startPosition = this.indentLeft() + (this.indentRight() - this.indentLeft() - image.getScaledWidth()) / 2.0f - mt[4];
        }
        if (image.hasAbsoluteX()) {
            startPosition = image.getAbsoluteX();
        }
        if (textwrap) {
            if (this.imageEnd < 0.0f || this.imageEnd < this.currentHeight + image.getScaledHeight() + diff) {
                this.imageEnd = this.currentHeight + image.getScaledHeight() + diff;
            }
            if ((image.getAlignment() & 2) == 2) {
                this.indentation.imageIndentRight += image.getScaledWidth() + image.getIndentationLeft();
            } else {
                this.indentation.imageIndentLeft += image.getScaledWidth() + image.getIndentationRight();
            }
        } else {
            startPosition = (image.getAlignment() & 2) == 2 ? (startPosition -= image.getIndentationRight()) : ((image.getAlignment() & 1) == 1 ? (startPosition += image.getIndentationLeft() - image.getIndentationRight()) : (startPosition += image.getIndentationLeft()));
        }
        this.graphics.addImage(image, mt[0], mt[1], mt[2], mt[3], startPosition, lowerleft - mt[5]);
        if (!textwrap && !underlying) {
            this.currentHeight += image.getScaledHeight() + diff;
            this.flushLines();
            this.text.moveText(0.0f, -(image.getScaledHeight() + diff));
            this.newLine();
        }
    }

    void addPTable(PdfPTable ptable) throws DocumentException {
        ColumnText ct = new ColumnText(PdfDocument.isTagged(this.writer) ? this.text : this.writer.getDirectContent());
        if (ptable.getKeepTogether() && !this.fitsPage(ptable, 0.0f) && this.currentHeight > 0.0f) {
            this.newPage();
        }
        if (this.currentHeight == 0.0f) {
            ct.setAdjustFirstLine(false);
        }
        ct.addElement(ptable);
        boolean he = ptable.isHeadersInEvent();
        ptable.setHeadersInEvent(true);
        int loop = 0;
        while (true) {
            ct.setSimpleColumn(this.indentLeft(), this.indentBottom(), this.indentRight(), this.indentTop() - this.currentHeight);
            int status = ct.go();
            if ((status & 1) != 0) {
                if (PdfDocument.isTagged(this.writer)) {
                    this.text.setTextMatrix(this.indentLeft(), ct.getYLine());
                    break;
                }
                this.text.moveText(0.0f, ct.getYLine() - this.indentTop() + this.currentHeight);
                break;
            }
            loop = this.indentTop() - this.currentHeight == ct.getYLine() ? ++loop : 0;
            if (loop == 3) {
                throw new DocumentException(MessageLocalization.getComposedMessage("infinite.table.loop", new Object[0]));
            }
            this.newPage();
            if (!PdfDocument.isTagged(this.writer)) continue;
            ct.setCanvas(this.text);
        }
        this.currentHeight = this.indentTop() - ct.getYLine();
        ptable.setHeadersInEvent(he);
    }

    private void addDiv(PdfDiv div) throws DocumentException {
        if (this.floatingElements == null) {
            this.floatingElements = new ArrayList();
        }
        this.floatingElements.add(div);
    }

    private void flushFloatingElements() throws DocumentException {
        if (this.floatingElements != null && !this.floatingElements.isEmpty()) {
            ArrayList<Element> cachedFloatingElements = this.floatingElements;
            this.floatingElements = null;
            FloatLayout fl = new FloatLayout(cachedFloatingElements, false);
            int loop = 0;
            while (true) {
                fl.setSimpleColumn(this.indentLeft(), this.indentBottom(), this.indentRight(), this.indentTop() - this.currentHeight);
                try {
                    int status = fl.layout(PdfDocument.isTagged(this.writer) ? this.text : this.writer.getDirectContent(), false);
                    if ((status & 1) != 0) {
                        if (PdfDocument.isTagged(this.writer)) {
                            this.text.setTextMatrix(this.indentLeft(), fl.getYLine());
                        } else {
                            this.text.moveText(0.0f, fl.getYLine() - this.indentTop() + this.currentHeight);
                        }
                        this.currentHeight = this.indentTop() - fl.getYLine();
                        break;
                    }
                }
                catch (Exception exc) {
                    return;
                }
                loop = this.indentTop() - this.currentHeight == fl.getYLine() || this.isPageEmpty() ? ++loop : 0;
                if (loop == 2) {
                    return;
                }
                this.newPage();
            }
        }
    }

    boolean fitsPage(PdfPTable table, float margin) {
        if (!table.isLockedWidth()) {
            float totalWidth = (this.indentRight() - this.indentLeft()) * table.getWidthPercentage() / 100.0f;
            table.setTotalWidth(totalWidth);
        }
        this.ensureNewLine();
        Float spaceNeeded = Float.valueOf(table.isSkipFirstHeader() ? table.getTotalHeight() - table.getHeaderHeight() : table.getTotalHeight());
        return spaceNeeded.floatValue() + (this.currentHeight > 0.0f ? table.spacingBefore() : 0.0f) <= this.indentTop() - this.currentHeight - this.indentBottom() - margin;
    }

    private static boolean isTagged(PdfWriter writer) {
        return writer != null && writer.isTagged();
    }

    private PdfLine getLastLine() {
        if (this.lines.size() > 0) {
            return this.lines.get(this.lines.size() - 1);
        }
        return null;
    }

    public class Destination {
        public PdfAction action;
        public PdfIndirectReference reference;
        public PdfDestination destination;
    }

    public static class Indentation {
        float indentLeft = 0.0f;
        float sectionIndentLeft = 0.0f;
        float listIndentLeft = 0.0f;
        float imageIndentLeft = 0.0f;
        float indentRight = 0.0f;
        float sectionIndentRight = 0.0f;
        float imageIndentRight = 0.0f;
        float indentTop = 0.0f;
        float indentBottom = 0.0f;
    }

    static class PdfCatalog
    extends PdfDictionary {
        PdfWriter writer;

        PdfCatalog(PdfIndirectReference pages, PdfWriter writer) {
            super(CATALOG);
            this.writer = writer;
            this.put(PdfName.PAGES, pages);
        }

        void addNames(TreeMap<String, Destination> localDestinations, HashMap<String, PdfObject> documentLevelJS, HashMap<String, PdfObject> documentFileAttachment, PdfWriter writer) {
            if (localDestinations.isEmpty() && documentLevelJS.isEmpty() && documentFileAttachment.isEmpty()) {
                return;
            }
            try {
                PdfDictionary names = new PdfDictionary();
                if (!localDestinations.isEmpty()) {
                    PdfArray ar = new PdfArray();
                    for (Map.Entry<String, Destination> entry : localDestinations.entrySet()) {
                        String name = entry.getKey();
                        Destination dest = entry.getValue();
                        if (dest.destination == null) continue;
                        PdfIndirectReference ref = dest.reference;
                        ar.add(new PdfString(name, null));
                        ar.add(ref);
                    }
                    if (ar.size() > 0) {
                        PdfDictionary dests = new PdfDictionary();
                        dests.put(PdfName.NAMES, ar);
                        names.put(PdfName.DESTS, writer.addToBody(dests).getIndirectReference());
                    }
                }
                if (!documentLevelJS.isEmpty()) {
                    PdfDictionary tree = PdfNameTree.writeTree(documentLevelJS, writer);
                    names.put(PdfName.JAVASCRIPT, writer.addToBody(tree).getIndirectReference());
                }
                if (!documentFileAttachment.isEmpty()) {
                    names.put(PdfName.EMBEDDEDFILES, writer.addToBody(PdfNameTree.writeTree(documentFileAttachment, writer)).getIndirectReference());
                }
                if (names.size() > 0) {
                    this.put(PdfName.NAMES, writer.addToBody(names).getIndirectReference());
                }
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }

        void setOpenAction(PdfAction action) {
            this.put(PdfName.OPENACTION, action);
        }

        void setAdditionalActions(PdfDictionary actions) {
            try {
                this.put(PdfName.AA, this.writer.addToBody(actions).getIndirectReference());
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
    }

    public static class PdfInfo
    extends PdfDictionary {
        PdfInfo() {
            this.addProducer();
            this.addCreationDate();
        }

        PdfInfo(String author, String title, String subject) {
            this();
            this.addTitle(title);
            this.addSubject(subject);
            this.addAuthor(author);
        }

        void addTitle(String title) {
            this.put(PdfName.TITLE, new PdfString(title, "UnicodeBig"));
        }

        void addSubject(String subject) {
            this.put(PdfName.SUBJECT, new PdfString(subject, "UnicodeBig"));
        }

        void addKeywords(String keywords) {
            this.put(PdfName.KEYWORDS, new PdfString(keywords, "UnicodeBig"));
        }

        void addAuthor(String author) {
            this.put(PdfName.AUTHOR, new PdfString(author, "UnicodeBig"));
        }

        void addCreator(String creator) {
            this.put(PdfName.CREATOR, new PdfString(creator, "UnicodeBig"));
        }

        void addProducer() {
            this.put(PdfName.PRODUCER, new PdfString(Version.getInstance().getVersion()));
        }

        void addCreationDate() {
            PdfDate date = new PdfDate();
            this.put(PdfName.CREATIONDATE, date);
            this.put(PdfName.MODDATE, date);
        }

        void addkey(String key, String value) {
            if (key.equals("Producer") || key.equals("CreationDate")) {
                return;
            }
            this.put(new PdfName(key), new PdfString(value, "UnicodeBig"));
        }
    }
}

