/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.SplitCharacter;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.DefaultSplitCharacter;
import com.itextpdf.text.pdf.HyphenationEvent;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfFont;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PdfChunk {
    private static final char[] singleSpace = new char[]{' '};
    private static final PdfChunk[] thisChunk = new PdfChunk[1];
    private static final float ITALIC_ANGLE = 0.21256f;
    private static final HashSet<String> keysAttributes = new HashSet();
    private static final HashSet<String> keysNoStroke = new HashSet();
    protected String value = "";
    protected String encoding = "Cp1252";
    protected PdfFont font;
    protected BaseFont baseFont;
    protected SplitCharacter splitCharacter;
    protected HashMap<String, Object> attributes = new HashMap();
    protected HashMap<String, Object> noStroke = new HashMap();
    protected boolean newlineSplit;
    protected Image image;
    protected float imageScalePercentage = 1.0f;
    protected float offsetX;
    protected float offsetY;
    protected boolean changeLeading = false;
    protected float leading = 0.0f;
    protected IAccessibleElement accessibleElement = null;

    static {
        keysAttributes.add("ACTION");
        keysAttributes.add("UNDERLINE");
        keysAttributes.add("REMOTEGOTO");
        keysAttributes.add("LOCALGOTO");
        keysAttributes.add("LOCALDESTINATION");
        keysAttributes.add("GENERICTAG");
        keysAttributes.add("NEWPAGE");
        keysAttributes.add("IMAGE");
        keysAttributes.add("BACKGROUND");
        keysAttributes.add("PDFANNOTATION");
        keysAttributes.add("SKEW");
        keysAttributes.add("HSCALE");
        keysAttributes.add("SEPARATOR");
        keysAttributes.add("TAB");
        keysAttributes.add("TABSPACE");
        keysAttributes.add("CHAR_SPACING");
        keysAttributes.add("LINEHEIGHT");
        keysNoStroke.add("SUBSUPSCRIPT");
        keysNoStroke.add("SPLITCHARACTER");
        keysNoStroke.add("HYPHENATION");
        keysNoStroke.add("TEXTRENDERMODE");
    }

    PdfChunk(String string, PdfChunk other) {
        PdfChunk.thisChunk[0] = this;
        this.value = string;
        this.font = other.font;
        this.attributes = other.attributes;
        this.noStroke = other.noStroke;
        this.baseFont = other.baseFont;
        this.changeLeading = other.changeLeading;
        this.leading = other.leading;
        Object[] obj = (Object[])this.attributes.get("IMAGE");
        if (obj == null) {
            this.image = null;
        } else {
            this.image = (Image)obj[0];
            this.offsetX = ((Float)obj[1]).floatValue();
            this.offsetY = ((Float)obj[2]).floatValue();
            this.changeLeading = (Boolean)obj[3];
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = DefaultSplitCharacter.DEFAULT;
        }
        this.accessibleElement = other.accessibleElement;
    }

    PdfChunk(Chunk chunk, PdfAction action) {
        Object[] obj;
        Object[][] unders;
        Object[] obj2;
        PdfChunk.thisChunk[0] = this;
        this.value = chunk.getContent();
        Font f = chunk.getFont();
        float size = f.getSize();
        if (size == -1.0f) {
            size = 12.0f;
        }
        this.baseFont = f.getBaseFont();
        int style = f.getStyle();
        if (style == -1) {
            style = 0;
        }
        if (this.baseFont == null) {
            this.baseFont = f.getCalculatedBaseFont(false);
        } else {
            if ((style & 1) != 0) {
                Object[] objectArray = new Object[3];
                objectArray[0] = 2;
                objectArray[1] = new Float(size / 30.0f);
                this.attributes.put("TEXTRENDERMODE", objectArray);
            }
            if ((style & 2) != 0) {
                this.attributes.put("SKEW", new float[]{0.0f, 0.21256f});
            }
        }
        this.font = new PdfFont(this.baseFont, size);
        HashMap<String, Object> attr = chunk.getAttributes();
        if (attr != null) {
            for (Map.Entry<String, Object> entry : attr.entrySet()) {
                String name = entry.getKey();
                if (keysAttributes.contains(name)) {
                    this.attributes.put(name, entry.getValue());
                    continue;
                }
                if (!keysNoStroke.contains(name)) continue;
                this.noStroke.put(name, entry.getValue());
            }
            if ("".equals(attr.get("GENERICTAG"))) {
                this.attributes.put("GENERICTAG", chunk.getContent());
            }
        }
        if (f.isUnderlined()) {
            Object[] objectArray = new Object[2];
            objectArray[1] = new float[]{0.0f, 0.06666667f, 0.0f, -0.33333334f, 0.0f};
            obj2 = objectArray;
            unders = Utilities.addToArray((Object[][])this.attributes.get("UNDERLINE"), obj2);
            this.attributes.put("UNDERLINE", unders);
        }
        if (f.isStrikethru()) {
            Object[] objectArray = new Object[2];
            objectArray[1] = new float[]{0.0f, 0.06666667f, 0.0f, 0.33333334f, 0.0f};
            obj2 = objectArray;
            unders = Utilities.addToArray((Object[][])this.attributes.get("UNDERLINE"), obj2);
            this.attributes.put("UNDERLINE", unders);
        }
        if (action != null) {
            this.attributes.put("ACTION", action);
        }
        this.noStroke.put("COLOR", f.getColor());
        this.noStroke.put("ENCODING", this.font.getFont().getEncoding());
        Float lh = (Float)this.attributes.get("LINEHEIGHT");
        if (lh != null) {
            this.changeLeading = true;
            this.leading = lh.floatValue();
        }
        if ((obj = (Object[])this.attributes.get("IMAGE")) == null) {
            this.image = null;
        } else {
            this.attributes.remove("HSCALE");
            this.image = (Image)obj[0];
            this.offsetX = ((Float)obj[1]).floatValue();
            this.offsetY = ((Float)obj[2]).floatValue();
            this.changeLeading = (Boolean)obj[3];
        }
        this.font.setImage(this.image);
        Float hs = (Float)this.attributes.get("HSCALE");
        if (hs != null) {
            this.font.setHorizontalScaling(hs.floatValue());
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = DefaultSplitCharacter.DEFAULT;
        }
        this.accessibleElement = chunk;
    }

    public int getUnicodeEquivalent(int c) {
        return this.baseFont.getUnicodeEquivalent(c);
    }

    protected int getWord(String text, int start) {
        int len = text.length();
        while (start < len) {
            if (!Character.isLetter(text.charAt(start))) break;
            ++start;
        }
        return start;
    }

    /*
     * Unable to fully structure code
     */
    PdfChunk split(float width) {
        block20: {
            this.newlineSplit = false;
            if (this.image != null) {
                if (this.image.getScaledWidth() > width) {
                    pc = new PdfChunk("\ufffc", this);
                    this.value = "";
                    this.attributes = new HashMap<K, V>();
                    this.image = null;
                    this.font = PdfFont.getDefaultFont();
                    return pc;
                }
                return null;
            }
            hyphenationEvent = (HyphenationEvent)this.noStroke.get("HYPHENATION");
            currentPosition = 0;
            splitPosition = -1;
            currentWidth = 0.0f;
            lastSpace = -1;
            lastSpaceWidth = 0.0f;
            length = this.value.length();
            valueArray = this.value.toCharArray();
            character = '\u0000';
            ft = this.font.getFont();
            surrogate = false;
            if (ft.getFontType() != 2 || ft.getUnicodeEquivalent(32) == 32) ** GOTO lbl68
            while (currentPosition < length) {
                cidChar = valueArray[currentPosition];
                character = (char)ft.getUnicodeEquivalent(cidChar);
                if (character == '\n') {
                    this.newlineSplit = true;
                    returnValue = this.value.substring(currentPosition + 1);
                    this.value = this.value.substring(0, currentPosition);
                    if (this.value.length() < 1) {
                        this.value = "\u0001";
                    }
                    pc = new PdfChunk(returnValue, this);
                    return pc;
                }
                currentWidth += this.getCharWidth(cidChar);
                if (character == ' ') {
                    lastSpace = currentPosition + 1;
                    lastSpaceWidth = currentWidth;
                }
                if (!(currentWidth > width)) {
                    if (this.splitCharacter.isSplitCharacter(0, currentPosition, length, valueArray, PdfChunk.thisChunk)) {
                        splitPosition = currentPosition + 1;
                    }
                    ++currentPosition;
                    continue;
                }
                break block20;
            }
            break block20;
lbl-1000:
            // 1 sources

            {
                character = valueArray[currentPosition];
                if (character == '\r' || character == '\n') {
                    this.newlineSplit = true;
                    inc = 1;
                    if (character == '\r' && currentPosition + 1 < length && valueArray[currentPosition + 1] == '\n') {
                        inc = 2;
                    }
                    returnValue = this.value.substring(currentPosition + inc);
                    this.value = this.value.substring(0, currentPosition);
                    if (this.value.length() < 1) {
                        this.value = " ";
                    }
                    pc = new PdfChunk(returnValue, this);
                    return pc;
                }
                surrogate = Utilities.isSurrogatePair(valueArray, currentPosition);
                currentWidth = surrogate ? (currentWidth += this.getCharWidth(Utilities.convertToUtf32(valueArray[currentPosition], valueArray[currentPosition + 1]))) : (currentWidth += this.getCharWidth(character));
                if (character == ' ') {
                    lastSpace = currentPosition + 1;
                    lastSpaceWidth = currentWidth;
                }
                if (surrogate) {
                    ++currentPosition;
                }
                if (currentWidth > width) break;
                if (this.splitCharacter.isSplitCharacter(0, currentPosition, length, valueArray, null)) {
                    splitPosition = currentPosition + 1;
                }
                ++currentPosition;
lbl68:
                // 2 sources

                ** while (currentPosition < length)
            }
        }
        if (currentPosition == length) {
            return null;
        }
        if (splitPosition < 0) {
            returnValue = this.value;
            this.value = "";
            pc = new PdfChunk(returnValue, this);
            return pc;
        }
        if (lastSpace > splitPosition && this.splitCharacter.isSplitCharacter(0, 0, 1, PdfChunk.singleSpace, null)) {
            splitPosition = lastSpace;
        }
        if (hyphenationEvent != null && lastSpace >= 0 && lastSpace < currentPosition && (wordIdx = this.getWord(this.value, lastSpace)) > lastSpace) {
            pre = hyphenationEvent.getHyphenatedWordPre(this.value.substring(lastSpace, wordIdx), this.font.getFont(), this.font.size(), width - lastSpaceWidth);
            post = hyphenationEvent.getHyphenatedWordPost();
            if (pre.length() > 0) {
                returnValue = String.valueOf(post) + this.value.substring(wordIdx);
                this.value = this.trim(String.valueOf(this.value.substring(0, lastSpace)) + pre);
                pc = new PdfChunk(returnValue, this);
                return pc;
            }
        }
        returnValue = this.value.substring(splitPosition);
        this.value = this.trim(this.value.substring(0, splitPosition));
        pc = new PdfChunk(returnValue, this);
        return pc;
    }

    PdfChunk truncate(float width) {
        if (this.image != null) {
            if (this.image.getScaledWidth() > width) {
                if (this.image.isScaleToFitLineWhenOverflow()) {
                    this.setImageScalePercentage(width / this.image.getWidth());
                    return null;
                }
                PdfChunk pc = new PdfChunk("", this);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = PdfFont.getDefaultFont();
                return pc;
            }
            return null;
        }
        int currentPosition = 0;
        float currentWidth = 0.0f;
        if (width < this.font.width()) {
            String returnValue = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            PdfChunk pc = new PdfChunk(returnValue, this);
            return pc;
        }
        int length = this.value.length();
        boolean surrogate = false;
        while (currentPosition < length) {
            surrogate = Utilities.isSurrogatePair(this.value, currentPosition);
            currentWidth = surrogate ? (currentWidth += this.getCharWidth(Utilities.convertToUtf32(this.value, currentPosition))) : (currentWidth += this.getCharWidth(this.value.charAt(currentPosition)));
            if (currentWidth > width) break;
            if (surrogate) {
                ++currentPosition;
            }
            ++currentPosition;
        }
        if (currentPosition == length) {
            return null;
        }
        if (currentPosition == 0) {
            currentPosition = 1;
            if (surrogate) {
                ++currentPosition;
            }
        }
        String returnValue = this.value.substring(currentPosition);
        this.value = this.value.substring(0, currentPosition);
        PdfChunk pc = new PdfChunk(returnValue, this);
        return pc;
    }

    PdfFont font() {
        return this.font;
    }

    BaseColor color() {
        return (BaseColor)this.noStroke.get("COLOR");
    }

    float width() {
        if (this.isAttribute("CHAR_SPACING")) {
            Float cs = (Float)this.getAttribute("CHAR_SPACING");
            return this.font.width(this.value) + (float)this.value.length() * cs.floatValue();
        }
        if (this.isAttribute("SEPARATOR")) {
            return 0.0f;
        }
        if (this.isAttribute("TABSPACE")) {
            return 0.0f;
        }
        return this.font.width(this.value);
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public float getWidthCorrected(float charSpacing, float wordSpacing) {
        if (this.image != null) {
            return this.image.getScaledWidth() + charSpacing;
        }
        int numberOfSpaces = 0;
        int idx = -1;
        while ((idx = this.value.indexOf(32, idx + 1)) >= 0) {
            ++numberOfSpaces;
        }
        return this.width() + (float)this.value.length() * charSpacing + (float)numberOfSpaces * wordSpacing;
    }

    public float getTextRise() {
        Float f = (Float)this.getAttribute("SUBSUPSCRIPT");
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public float trimLastSpace() {
        BaseFont ft = this.font.getFont();
        if (ft.getFontType() == 2 && ft.getUnicodeEquivalent(32) != 32) {
            if (this.value.length() > 1 && this.value.endsWith("\u0001")) {
                this.value = this.value.substring(0, this.value.length() - 1);
                return this.font.width(1);
            }
        } else if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            return this.font.width(32);
        }
        return 0.0f;
    }

    public float trimFirstSpace() {
        BaseFont ft = this.font.getFont();
        if (ft.getFontType() == 2 && ft.getUnicodeEquivalent(32) != 32) {
            if (this.value.length() > 1 && this.value.startsWith("\u0001")) {
                this.value = this.value.substring(1);
                return this.font.width(1);
            }
        } else if (this.value.length() > 1 && this.value.startsWith(" ")) {
            this.value = this.value.substring(1);
            return this.font.width(32);
        }
        return 0.0f;
    }

    Object getAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            return this.attributes.get(name);
        }
        return this.noStroke.get(name);
    }

    boolean isAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            return true;
        }
        return this.noStroke.containsKey(name);
    }

    boolean isStroked() {
        return !this.attributes.isEmpty();
    }

    boolean isSeparator() {
        return this.isAttribute("SEPARATOR");
    }

    boolean isHorizontalSeparator() {
        if (this.isAttribute("SEPARATOR")) {
            Object[] o = (Object[])this.getAttribute("SEPARATOR");
            return (Boolean)o[1] == false;
        }
        return false;
    }

    boolean isTab() {
        return this.isAttribute("TAB");
    }

    boolean isTabSpace() {
        return this.isAttribute("TABSPACE");
    }

    void adjustLeft(float newValue) {
        Object[] o = (Object[])this.attributes.get("TAB");
        if (o != null) {
            this.attributes.put("TAB", new Object[]{o[0], o[1], o[2], new Float(newValue)});
        }
    }

    boolean isImage() {
        return this.image != null;
    }

    Image getImage() {
        return this.image;
    }

    float getImageHeight() {
        return this.image.getScaledHeight() * this.imageScalePercentage;
    }

    float getImageWidth() {
        return this.image.getScaledWidth() * this.imageScalePercentage;
    }

    public float getImageScalePercentage() {
        return this.imageScalePercentage;
    }

    public void setImageScalePercentage(float imageScalePercentage) {
        this.imageScalePercentage = imageScalePercentage;
    }

    void setImageOffsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    float getImageOffsetX() {
        return this.offsetX;
    }

    void setImageOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    float getImageOffsetY() {
        return this.offsetY;
    }

    void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    boolean isSpecialEncoding() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    String getEncoding() {
        return this.encoding;
    }

    int length() {
        return this.value.length();
    }

    int lengthUtf32() {
        if (!"Identity-H".equals(this.encoding)) {
            return this.value.length();
        }
        int total = 0;
        int len = this.value.length();
        int k = 0;
        while (k < len) {
            if (Utilities.isSurrogateHigh(this.value.charAt(k))) {
                ++k;
            }
            ++total;
            ++k;
        }
        return total;
    }

    boolean isExtSplitCharacter(int start, int current, int end, char[] cc, PdfChunk[] ck) {
        return this.splitCharacter.isSplitCharacter(start, current, end, cc, ck);
    }

    /*
     * Unable to fully structure code
     */
    String trim(String string) {
        block2: {
            ft = this.font.getFont();
            if (ft.getFontType() != 2 || ft.getUnicodeEquivalent(32) == 32) ** GOTO lbl8
            while (string.endsWith("\u0001")) {
                string = string.substring(0, string.length() - 1);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                string = string.substring(0, string.length() - 1);
lbl8:
                // 2 sources

                ** while (string.endsWith((String)" ") || string.endsWith((String)"\t"))
            }
        }
        return string;
    }

    public boolean changeLeading() {
        return this.changeLeading;
    }

    public float getLeading() {
        return this.leading;
    }

    float getCharWidth(int c) {
        if (PdfChunk.noPrint(c)) {
            return 0.0f;
        }
        if (this.isAttribute("CHAR_SPACING")) {
            Float cs = (Float)this.getAttribute("CHAR_SPACING");
            return this.font.width(c) + cs.floatValue() * this.font.getHorizontalScaling();
        }
        return this.font.width(c);
    }

    public static boolean noPrint(int c) {
        return c >= 8203 && c <= 8207 || c >= 8234 && c <= 8238;
    }
}

