/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class MappedRandomAccessFile {
    private static final int BUFSIZE = 0x40000000;
    private FileChannel channel = null;
    private MappedByteBuffer[] mappedBuffers;
    private long size;
    private long pos;

    public MappedRandomAccessFile(String filename, String mode) throws FileNotFoundException, IOException {
        if (mode.equals("rw")) {
            this.init(new RandomAccessFile(filename, mode).getChannel(), FileChannel.MapMode.READ_WRITE);
        } else {
            this.init(new FileInputStream(filename).getChannel(), FileChannel.MapMode.READ_ONLY);
        }
    }

    private void init(FileChannel channel, FileChannel.MapMode mapMode) throws IOException {
        this.channel = channel;
        this.size = channel.size();
        this.pos = 0L;
        int requiredBuffers = (int)(this.size / 0x40000000L) + (this.size % 0x40000000L == 0L ? 0 : 1);
        this.mappedBuffers = new MappedByteBuffer[requiredBuffers];
        try {
            int index = 0;
            long offset = 0L;
            while (offset < this.size) {
                long size2 = Math.min(this.size - offset, 0x40000000L);
                this.mappedBuffers[index] = channel.map(mapMode, offset, size2);
                this.mappedBuffers[index].load();
                ++index;
                offset += 0x40000000L;
            }
            if (index != requiredBuffers) {
                throw new Error("Should never happen - " + index + " != " + requiredBuffers);
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    public int read() {
        int offN;
        int mapN;
        block5: {
            block4: {
                try {
                    mapN = (int)(this.pos / 0x40000000L);
                    offN = (int)(this.pos % 0x40000000L);
                    if (mapN < this.mappedBuffers.length) break block4;
                    return -1;
                }
                catch (BufferUnderflowException e) {
                    return -1;
                }
            }
            if (offN < this.mappedBuffers[mapN].limit()) break block5;
            return -1;
        }
        byte b = this.mappedBuffers[mapN].get(offN);
        ++this.pos;
        int n = b & 0xFF;
        return n;
    }

    public int read(byte[] bytes, int off, int len) {
        int mapN = (int)(this.pos / 0x40000000L);
        int offN = (int)(this.pos % 0x40000000L);
        int totalRead = 0;
        while (totalRead < len) {
            MappedByteBuffer currentBuffer;
            if (mapN >= this.mappedBuffers.length || offN > (currentBuffer = this.mappedBuffers[mapN]).limit()) break;
            currentBuffer.position(offN);
            int bytesFromThisBuffer = Math.min(len - totalRead, currentBuffer.remaining());
            currentBuffer.get(bytes, off, bytesFromThisBuffer);
            off += bytesFromThisBuffer;
            this.pos += (long)bytesFromThisBuffer;
            totalRead += bytesFromThisBuffer;
            ++mapN;
            offN = 0;
        }
        return totalRead == 0 ? -1 : totalRead;
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void seek(long pos) {
        this.pos = pos;
    }

    public long length() {
        return this.size;
    }

    public void close() throws IOException {
        int i = 0;
        while (i < this.mappedBuffers.length) {
            if (this.mappedBuffers[i] != null) {
                MappedRandomAccessFile.clean(this.mappedBuffers[i]);
                this.mappedBuffers[i] = null;
            }
            ++i;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static boolean clean(final ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return false;
        }
        Boolean b = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Boolean success = Boolean.FALSE;
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", null);
                    getCleanerMethod.setAccessible(true);
                    Object cleaner = getCleanerMethod.invoke((Object)buffer, null);
                    Method clean = cleaner.getClass().getMethod("clean", null);
                    clean.invoke(cleaner, null);
                    success = Boolean.TRUE;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return success;
            }
        });
        return b;
    }
}

