/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.io;

import com.itextpdf.text.io.RandomAccessSource;
import java.io.IOException;

class GroupedRandomAccessSource
implements RandomAccessSource {
    private final SourceEntry[] sources;
    private SourceEntry currentSourceEntry;
    private final long size;

    public GroupedRandomAccessSource(RandomAccessSource[] sources) throws IOException {
        this.sources = new SourceEntry[sources.length];
        long totalSize = 0L;
        int i = 0;
        while (i < sources.length) {
            this.sources[i] = new SourceEntry(i, sources[i], totalSize);
            totalSize += sources[i].length();
            ++i;
        }
        this.size = totalSize;
        this.currentSourceEntry = this.sources[sources.length - 1];
        this.sourceInUse(this.currentSourceEntry.source);
    }

    protected int getStartingSourceIndex(long offset) {
        if (offset >= this.currentSourceEntry.firstByte) {
            return this.currentSourceEntry.index;
        }
        return 0;
    }

    private SourceEntry getSourceEntryForOffset(long offset) throws IOException {
        int startAt;
        if (offset >= this.size) {
            return null;
        }
        if (offset >= this.currentSourceEntry.firstByte && offset <= this.currentSourceEntry.lastByte) {
            return this.currentSourceEntry;
        }
        this.sourceReleased(this.currentSourceEntry.source);
        int i = startAt = this.getStartingSourceIndex(offset);
        while (i < this.sources.length) {
            if (offset >= this.sources[i].firstByte && offset <= this.sources[i].lastByte) {
                this.currentSourceEntry = this.sources[i];
                this.sourceInUse(this.currentSourceEntry.source);
                return this.currentSourceEntry;
            }
            ++i;
        }
        return null;
    }

    protected void sourceReleased(RandomAccessSource source) throws IOException {
    }

    protected void sourceInUse(RandomAccessSource source) throws IOException {
    }

    @Override
    public int get(long position) throws IOException {
        SourceEntry entry = this.getSourceEntryForOffset(position);
        if (entry == null) {
            return -1;
        }
        return entry.source.get(entry.offsetN(position));
    }

    @Override
    public int get(long position, byte[] bytes, int off, int len) throws IOException {
        SourceEntry entry = this.getSourceEntryForOffset(position);
        if (entry == null) {
            return -1;
        }
        long offN = entry.offsetN(position);
        int remaining = len;
        while (remaining > 0) {
            int count;
            if (entry == null || offN > entry.source.length() || (count = entry.source.get(offN, bytes, off, remaining)) == -1) break;
            off += count;
            remaining -= count;
            offN = 0L;
            entry = this.getSourceEntryForOffset(position += (long)count);
        }
        return remaining == len ? -1 : len - remaining;
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        SourceEntry[] sourceEntryArray = this.sources;
        int n = this.sources.length;
        int n2 = 0;
        while (n2 < n) {
            SourceEntry entry = sourceEntryArray[n2];
            entry.source.close();
            ++n2;
        }
    }

    private static class SourceEntry {
        final RandomAccessSource source;
        final long firstByte;
        final long lastByte;
        final int index;

        public SourceEntry(int index, RandomAccessSource source, long offset) {
            this.index = index;
            this.source = source;
            this.firstByte = offset;
            this.lastByte = offset + source.length() - 1L;
        }

        public long offsetN(long absoluteOffset) {
            return absoluteOffset - this.firstByte;
        }
    }
}

