/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html;

import com.itextpdf.text.BaseColor;
import java.util.HashSet;
import java.util.Set;

public final class HtmlEncoder {
    private static final String[] HTML_CODE = new String[256];
    private static final Set<String> NEWLINETAGS;

    static {
        int i = 0;
        while (i < 10) {
            HtmlEncoder.HTML_CODE[i] = "&#00" + i + ";";
            ++i;
        }
        i = 10;
        while (i < 32) {
            HtmlEncoder.HTML_CODE[i] = "&#0" + i + ";";
            ++i;
        }
        i = 32;
        while (i < 128) {
            HtmlEncoder.HTML_CODE[i] = String.valueOf((char)i);
            ++i;
        }
        HtmlEncoder.HTML_CODE[9] = "\t";
        HtmlEncoder.HTML_CODE[10] = "<br />\n";
        HtmlEncoder.HTML_CODE[34] = "&quot;";
        HtmlEncoder.HTML_CODE[38] = "&amp;";
        HtmlEncoder.HTML_CODE[60] = "&lt;";
        HtmlEncoder.HTML_CODE[62] = "&gt;";
        i = 128;
        while (i < 256) {
            HtmlEncoder.HTML_CODE[i] = "&#" + i + ";";
            ++i;
        }
        NEWLINETAGS = new HashSet<String>();
        NEWLINETAGS.add("p");
        NEWLINETAGS.add("blockquote");
        NEWLINETAGS.add("br");
    }

    private HtmlEncoder() {
    }

    public static String encode(String string) {
        int n = string.length();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < n) {
            char character = string.charAt(i);
            if (character < '\u0100') {
                buffer.append(HTML_CODE[character]);
            } else {
                buffer.append("&#").append((int)character).append(';');
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String encode(BaseColor color) {
        StringBuffer buffer = new StringBuffer("#");
        if (color.getRed() < 16) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(color.getRed(), 16));
        if (color.getGreen() < 16) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(color.getGreen(), 16));
        if (color.getBlue() < 16) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(color.getBlue(), 16));
        return buffer.toString();
    }

    public static String getAlignment(int alignment) {
        switch (alignment) {
            case 0: {
                return "left";
            }
            case 1: {
                return "center";
            }
            case 2: {
                return "right";
            }
            case 3: 
            case 8: {
                return "justify";
            }
            case 4: {
                return "top";
            }
            case 5: {
                return "middle";
            }
            case 6: {
                return "bottom";
            }
            case 7: {
                return "baseline";
            }
        }
        return "";
    }

    public static boolean isNewLineTag(String tag) {
        return NEWLINETAGS.contains(tag);
    }
}

