/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;

public class RectangleReadOnly
extends Rectangle {
    public RectangleReadOnly(float llx, float lly, float urx, float ury) {
        super(llx, lly, urx, ury);
    }

    public RectangleReadOnly(float llx, float lly, float urx, float ury, int rotation) {
        super(llx, lly, urx, ury);
        super.setRotation(rotation);
    }

    public RectangleReadOnly(float urx, float ury) {
        super(0.0f, 0.0f, urx, ury);
    }

    public RectangleReadOnly(float urx, float ury, int rotation) {
        super(0.0f, 0.0f, urx, ury);
        super.setRotation(rotation);
    }

    public RectangleReadOnly(Rectangle rect) {
        super(rect.llx, rect.lly, rect.urx, rect.ury);
        super.cloneNonPositionParameters(rect);
    }

    private void throwReadOnlyError() {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("rectanglereadonly.this.rectangle.is.read.only", new Object[0]));
    }

    @Override
    public void setRotation(int rotation) {
        this.throwReadOnlyError();
    }

    @Override
    public void setLeft(float llx) {
        this.throwReadOnlyError();
    }

    @Override
    public void setRight(float urx) {
        this.throwReadOnlyError();
    }

    @Override
    public void setTop(float ury) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBottom(float lly) {
        this.throwReadOnlyError();
    }

    @Override
    public void normalize() {
        this.throwReadOnlyError();
    }

    @Override
    public void setBackgroundColor(BaseColor value) {
        this.throwReadOnlyError();
    }

    @Override
    public void setGrayFill(float value) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorder(int border) {
        this.throwReadOnlyError();
    }

    @Override
    public void setUseVariableBorders(boolean useVariableBorders) {
        this.throwReadOnlyError();
    }

    @Override
    public void enableBorderSide(int side) {
        this.throwReadOnlyError();
    }

    @Override
    public void disableBorderSide(int side) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorderWidth(float borderWidth) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorderWidthLeft(float borderWidthLeft) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorderWidthRight(float borderWidthRight) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorderWidthTop(float borderWidthTop) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorderWidthBottom(float borderWidthBottom) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorderColor(BaseColor borderColor) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorderColorLeft(BaseColor borderColorLeft) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorderColorRight(BaseColor borderColorRight) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorderColorTop(BaseColor borderColorTop) {
        this.throwReadOnlyError();
    }

    @Override
    public void setBorderColorBottom(BaseColor borderColorBottom) {
        this.throwReadOnlyError();
    }

    @Override
    public void cloneNonPositionParameters(Rectangle rect) {
        this.throwReadOnlyError();
    }

    @Override
    public void softCloneNonPositionParameters(Rectangle rect) {
        this.throwReadOnlyError();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("RectangleReadOnly: ");
        buf.append(this.getWidth());
        buf.append('x');
        buf.append(this.getHeight());
        buf.append(" (rot: ");
        buf.append(this.rotation);
        buf.append(" degrees)");
        return buf.toString();
    }
}

