/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package org.springframework.security.web.session;

import it.laitspa.cpf.util.log.LogUtils;

import java.net.HttpURLConnection;
import java.net.URL;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * @author andrea
 * 
 */
public class ServiceListener
  implements ServletContextListener
{

  public static Integer TIMEOUT = new Integer(10000);

  @Override
  public void contextDestroyed(ServletContextEvent arg0)
  {
    // Nothing.
    //
  }

  @Override
  public void contextInitialized(ServletContextEvent arg0)
  {
    // Try to fast connect to service.
    //
    HttpURLConnection connection = null;
    try
    {
      URL url = new URL("http://pserv.cloudapp.net/pserv/rest/pserv/alive?prop=sdidpa");
      connection = (HttpURLConnection)url.openConnection();
      connection.setConnectTimeout(TIMEOUT);
      connection.setReadTimeout(TIMEOUT);
      connection.setRequestMethod("GET");

      if(connection.getResponseCode() != 200)
      {
        LogUtils.warn(getClass(), "Service return code: " + connection.getResponseCode());
      }
    }
    catch(Exception e)
    {
      // Nothing.
      //
    }
    finally
    {
      if (connection != null)
        connection.disconnect();
    }
  }

}
