package it.laitspa.xsd.adapter;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import java.text.SimpleDateFormat;
import java.util.*;


public class DateAdapter extends XmlAdapter<String, XMLGregorianCalendar> {



    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public String marshal(XMLGregorianCalendar v) throws Exception {
      Calendar calendar = v.toGregorianCalendar();
      String dateString = dateFormat.format(calendar.getTime());
      return dateString;
    }

    @Override
    public XMLGregorianCalendar unmarshal(String v) throws Exception {
      return DatatypeFactory.newInstance().newXMLGregorianCalendar(v);
    }

}
