/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.util.sdi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataSource;

/**
 * @author andrea
 *
 */
public class InputStreamDatasource
  implements DataSource
{

  protected InputStream is;
  
  public InputStreamDatasource(InputStream is)
  {
    this.is = is;
  }
  
  /* (non-Javadoc)
   * @see javax.activation.DataSource#getContentType()
   */
  @Override
  public String getContentType()
  {
    // handle all content types.
    //
    return "*/*";
  }

  /* (non-Javadoc)
   * @see javax.activation.DataSource#getInputStream()
   */
  @Override
  public InputStream getInputStream()
    throws IOException
  {
    return is;
  }

  /* (non-Javadoc)
   * @see javax.activation.DataSource#getName()
   */
  @Override
  public String getName()
  {
    return "SanferCustomInputDataSource";
  }

  /* (non-Javadoc)
   * @see javax.activation.DataSource#getOutputStream()
   */
  @Override
  public OutputStream getOutputStream()
    throws IOException
  {
    // OutputStream is not implemented.
    //
    throw new UnsupportedOperationException("OutputStream is not implemented for custom InputStreamDataSource.");
  }

}
