/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.util.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils
{
  public static byte[] createZip(byte[] data, String filename) 
    throws IOException
  {
    if(data == null)
      return null;

    // Open output stream.
    //
    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
    ZipOutputStream zos = new ZipOutputStream(baos);
    ZipEntry ze = new ZipEntry(filename);
    zos.putNextEntry(ze);

    // Open input stream.
    //
    ByteArrayInputStream bais = new ByteArrayInputStream(data);
    
    int c;
    while((c = bais.read()) != -1)
      zos.write(c);
    
    zos.closeEntry();
    zos.close();
    baos.close();
    
    return(baos.toByteArray());
  }
}
