/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.util.misc;

import java.io.InputStream;
import java.util.Properties;

import org.apache.log4j.Logger;

/**
 * 
 * @author andrea
 *
 */

public class PropertiesLoader
{
  
  protected Logger logger = Logger.getLogger(this.getClass());

  protected Properties properties;
  
  
  public PropertiesLoader(String fileName)
  {
    properties = loadProperties(fileName);
  }
  
  
  public Properties loadProperties(String fileName)
  {
    // Read configuration from properties file.
    //
    properties = null;
    try
    {
      properties = new Properties();
      InputStream is = getClass().getResourceAsStream(fileName);
      properties.load(is);
    }
    catch(Exception e)
    {
      logger.error("Unable to load specified properties.", e);
      return null;
    }

    return properties;
  }
  
  
  public int getInteger(String property)
  {
    String s = properties.getProperty(property);
    
    if(s == null)
      return 0;
    
    try
    {
      return Integer.parseInt(s);
    }
    catch(NumberFormatException e)
    {
      logger.error("Unable to parse property as integer.", e);
      return 0;
    }
  }
  
  
  public String getString(String property)
  {
    return properties.getProperty(property);
  }
  
  
  public boolean getYesNo(String property)
  {
    boolean b = false;
    String s = properties.getProperty("idmusermanager.useproxy");
    if(s != null && s.equalsIgnoreCase("yes"))
      b = true;
    
    return b;
  }


  public Properties getProperties()
  {
    return properties;
  }
}
