/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.util.mail;

import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;


public class MailDbUtils extends MailUtils
{
  
  protected StringBuffer html;
  protected StringBuffer plain;
  

  public MailDbUtils()
  {
    super();
  }
  
  @Override
  public VelocityEngine getEngine()
  {
    VelocityEngine ve = super.getEngine();
    
    // Adding String Resource Loader.
    //
    ve.setProperty(RuntimeConstants.RESOURCE_LOADER, "string");
    ve.setProperty("string.resource.loader.description", "Velocity StringResource loader for db entities");
    ve.setProperty("string.resource.loader.class", "org.apache.velocity.runtime.resource.loader.StringResourceLoader");
    ve.setProperty("string.resource.loader.repository.class", "org.apache.velocity.runtime.resource.loader.StringResourceRepositoryImpl");
    ve.setProperty("string.resource.loader.repository.name","sanfer");
    return ve;
  }
  
  
  
  
  public StringBuffer getHtml()
  {
    return html;
  }

  public void setHtml(StringBuffer html)
  {
    this.html = html;
  }

  public StringBuffer getPlain()
  {
    return plain;
  }

  public void setPlain(StringBuffer plain)
  {
    this.plain = plain;
  }

  @Override
  public Template getPlainTemplate(VelocityEngine ve)
  {
    if (plain == null)
      return null;
    
    StringResourceRepository repo = StringResourceLoader.getRepository("sanfer");
    String template_name = "/templates/mail/" + template + ".plain.vm";
    String myTemplate = plain.toString();
    repo.putStringResource(template_name, myTemplate);
    return super.getPlainTemplate(ve);
  }
  
  @Override
  public Template getHtmlTemplate(VelocityEngine ve)
  {
    if (html == null)
      return null;
    
    StringResourceRepository repo = StringResourceLoader.getRepository("sanfer");
    String template_name = "/templates/mail/" + template + ".html.vm";
    String myTemplate = html.toString();
    repo.putStringResource(template_name, myTemplate);
    return super.getHtmlTemplate(ve);
  }
  

}