/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.util.mail;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataSource;

public class ByteArrayDataSource
  implements DataSource
{
  private byte[] data        = new byte[0];
  private String contentType = "text/plain";
  private String name        = null;

  public void setData(byte[] data)
  {
    this.data = data;
  }

  public void setContentType(String contentType)
  {
    this.contentType = contentType;
  }

  public void setName(String name)
  {
    this.name = name;
  }

  public InputStream getInputStream()
  {
    return new ByteArrayInputStream(data);
  }

  public OutputStream getOutputStream()
  {
    return null;
  }

  public String getContentType()
  {
    return contentType;
  }

  public String getName()
  {
    return name;
  }
}