/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.util.log;

import java.text.MessageFormat;

import org.apache.log4j.Logger;

public class LogUtils
{

  public static void info(Class<?> clazz, String info)
  {
    info(clazz, info, null, null);
  }
  
  public static void info(Class<?> clazz, String info, Object[] params)
  {
    info(clazz, info, null, params);
  }
  
  public static void info(Class<?> clazz, String info, Throwable e)
  {
    info(clazz, info, e, null);
  }
  
  public static void info(Class<?> clazz, String info, Throwable e, Object[] params)
  {
    Logger logger = Logger.getLogger(clazz);
    
    if (params != null && params.length > 0)
      info = format(info, params);
    
    if (e == null)
      logger.info(info);
    else
      logger.info(info, e);
  }
  
  
  public static void error(Class<?> clazz, String info)
  {
    error(clazz, info, null);
  }
  
  public static void error(Class<?> clazz, String info, Throwable e)
  {
    Logger logger = Logger.getLogger(clazz);
    if (e == null)
      logger.error(info);
    else
      logger.error(info, e);
  }
  
  public static void error(Class<?> clazz, Throwable e)
  {
    Logger logger = Logger.getLogger(clazz);
    if (e != null)
      logger.error(e);
  }
  
  public static void debug(Class<?> clazz, String info)
  {
    debug(clazz, info, null);
  }
  
  public static void debug(Class<?> clazz, String info, Throwable e)
  {
    Logger logger = Logger.getLogger(clazz);
    if (e == null)
      logger.debug(info);
    else
      logger.debug(info, e);
  }
  
  public static String format(String info, Object[] params)
  {
    return MessageFormat.format(info, params);
  }

  public static void warn(Class<?> clazz, String warn)
  {
    warn(clazz, warn, null);
  }
  
  public static void warn(Class<?> clazz, String info, Object[] params)
  {
    Logger logger = Logger.getLogger(clazz);
    
    if (params != null && params.length > 0)
      info = format(info, params);
     
    logger.warn(info);
  }
  
}
