/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.statoinvio;

import it.laitspa.cpf.model.Entity;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_STAT_INVIO")
public class StatoInvioSogei
  extends Entity
{
  /**
   * 
   */
  private static final long   serialVersionUID = 1L;
  public static final Integer IMMESSO          = new Integer(1);
  public static final Integer RICEVUTO         = new Integer(2);
  public static final Integer INVIATO          = new Integer(3); // INSERITO
  public static final Integer CONFERMATO       = new Integer(4); // PRELEVATO
  public static final Integer SCARTATO         = new Integer(5);
  public static final Integer NON_INVIATO      = new Integer(6); // IN_ERRORE
  public static final Integer IN_ATTESA_FIRMA  = new Integer(7); // BOZZA

  @Id
  @Column(name = "CODI_STAT", nullable = false)
  private Integer             codice;
  @Column(name = "DESC_STAT", nullable = false)
  private String              descrizione;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getDescrizione()
  {
    return descrizione;
  }

  public void setDescrizione(String descrizione)
  {
    this.descrizione = descrizione;
  }


  @Transient
  public boolean isAttesaFirma()
  {
    return this.codice.equals(IN_ATTESA_FIRMA);
  }
  
}
