/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.riga;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.tiponatura.TipoNaturaSogei;
import it.laitspa.cpf.model.sogei.tipoprestazione.TipoPrestazioneSogei;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_RIGA_FATT")
public class RigaFatturaSogei
  extends Entity
{
  /**
   * 
   */
  private static final long    serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen_rfld", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen_rfld", sequenceName = "SEQ_SAN_CPF_SOGEI_RIGA_FATT",
      allocationSize = 1)
  @Column(name = "CODI_RIGA_SOGE", nullable = false)
  private Integer              codice;

  @ManyToOne(targetEntity = FatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_FATT_SOGE", nullable = false)
  private FatturaSogei         fattura;

  @Column(name = "NUME_PROG", nullable = false)
  private Integer              numeroProgressivo;

  @ManyToOne(targetEntity = TipoPrestazioneSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_PRST")
  private TipoPrestazioneSogei tipoPrestazione;

  @Column(name = "DESC_RIGA", length = 100, nullable = false)
  private String               descrizione;

  @Column(name = "NUME_QUAN")
  private BigDecimal           quantita;

  @Column(name = "DESC_UNIT_MISU", length = 10)
  private String               unitaMisura;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_INIZ")
  private Date                 dataInizioPeriodo;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_FINE")
  private Date                 dataFinePeriodo;

  @Column(name = "NUME_IMPT_UNIT", nullable = false)
  private BigDecimal           importoUnitario;

  @Column(name = "NUME_IMPT_TOTA", nullable = false)
  private BigDecimal           importoTotale;

  @Column(name = "NUME_ALIQ", nullable = false)
  private BigDecimal           aliquotaIva;

  @Type(type = "yes_no")
  @Column(name = "FLAG_RITE")
  private Boolean              flagRitenuta;

  @Column(name = "DESC_RIFE_AMMI", length = 100)
  private String               riferimentoNormativo;

  @ManyToOne(targetEntity = TipoNaturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_NATU")
  private TipoNaturaSogei      tipoNatura;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public FatturaSogei getFattura()
  {
    return fattura;
  }

  public void setFattura(FatturaSogei fattura)
  {
    this.fattura = fattura;
  }

  public Integer getNumeroProgressivo()
  {
    return numeroProgressivo;
  }

  public void setNumeroProgressivo(Integer numeroProgressivo)
  {
    this.numeroProgressivo = numeroProgressivo;
  }

  public TipoPrestazioneSogei getTipoPrestazione()
  {
    return tipoPrestazione;
  }

  public void setTipoPrestazione(TipoPrestazioneSogei tipoPrestazione)
  {
    this.tipoPrestazione = tipoPrestazione;
  }

  public String getDescrizione()
  {
    return descrizione;
  }

  public void setDescrizione(String descrizione)
  {
    this.descrizione = descrizione;
  }

  public BigDecimal getQuantita()
  {
    return quantita;
  }

  public void setQuantita(BigDecimal quantita)
  {
    this.quantita = quantita;
  }

  public String getUnitaMisura()
  {
    return unitaMisura;
  }

  public void setUnitaMisura(String unitaMisura)
  {
    this.unitaMisura = unitaMisura;
  }

  public Date getDataInizioPeriodo()
  {
    return dataInizioPeriodo;
  }

  public void setDataInizioPeriodo(Date dataInizioPeriodo)
  {
    this.dataInizioPeriodo = dataInizioPeriodo;
  }

  public Date getDataFinePeriodo()
  {
    return dataFinePeriodo;
  }

  public void setDataFinePeriodo(Date dataFinePeriodo)
  {
    this.dataFinePeriodo = dataFinePeriodo;
  }

  public BigDecimal getImportoUnitario()
  {
    return importoUnitario;
  }

  public void setImportoUnitario(BigDecimal importoUnitario)
  {
    this.importoUnitario = importoUnitario;
  }

  public BigDecimal getImportoTotale()
  {
    return importoTotale;
  }

  public void setImportoTotale(BigDecimal importoTotale)
  {
    this.importoTotale = importoTotale;
  }

  public BigDecimal getAliquotaIva()
  {
    return aliquotaIva;
  }

  public void setAliquotaIva(BigDecimal aliquotaIva)
  {
    this.aliquotaIva = aliquotaIva;
  }

  public Boolean getFlagRitenuta()
  {
    return flagRitenuta;
  }

  public void setFlagRitenuta(Boolean flagRitenuta)
  {
    this.flagRitenuta = flagRitenuta;
  }

  public String getRiferimentoNormativo()
  {
    return riferimentoNormativo;
  }

  public void setRiferimentoNormativo(String riferimentoNormativo)
  {
    this.riferimentoNormativo = riferimentoNormativo;
  }

  public TipoNaturaSogei getTipoNatura()
  {
    return tipoNatura;
  }

  public void setTipoNatura(TipoNaturaSogei tipoNatura)
  {
    this.tipoNatura = tipoNatura;
  }

}
