/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.inviofilesdi;

import it.laitspa.cpf.model.Entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_OBJTFILE")
public class AllegatoInvioFileSdiSogei
  extends Entity
{
  /**
   * 
   */
  private static final long             serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_fileall_gen", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_fileall_gen", sequenceName = "SEQ_SAN_CPF_SOGEI_OBJTFILE",
      allocationSize = 1)
  @Column(name = "CODI_OBJT_INVI", nullable = false)
  private Integer                       codice;

  @Lob
  @Column(name = "OBJT_FILE", nullable = false)
  private byte[]                        datafile;

  @ManyToOne(targetEntity = InvioFileSdiSogei.class, fetch = FetchType.EAGER)
  @JoinColumn(name = "CODI_INVI", nullable = false)
  private InvioFileSdiSogei             file;

  @ManyToOne(targetEntity = TipoAllegatoInvioFileSdiSogei.class, fetch = FetchType.EAGER)
  @JoinColumn(name = "CODI_TIPO", nullable = false)
  private TipoAllegatoInvioFileSdiSogei tipoAllegato;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_CREA")
  private Date                          dataCreazione    = new Date();

  @Column(name = "DESC_FILE", length = 255)
  private String                        nomeFile;

  @Column(name = "DESC_TYPE", length = 50)
  private String                        estensione;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public byte[] getDatafile()
  {
    return datafile;
  }

  public void setDatafile(byte[] datafile)
  {
    this.datafile = datafile;
  }

  public InvioFileSdiSogei getFile()
  {
    return file;
  }

  public void setFile(InvioFileSdiSogei file)
  {
    this.file = file;
  }

  public TipoAllegatoInvioFileSdiSogei getTipoAllegato()
  {
    return tipoAllegato;
  }

  public void setTipoAllegato(TipoAllegatoInvioFileSdiSogei tipoAllegato)
  {
    this.tipoAllegato = tipoAllegato;
  }

  public Date getDataCreazione()
  {
    return dataCreazione;
  }

  public void setDataCreazione(Date dataCreazione)
  {
    this.dataCreazione = dataCreazione;
  }

  public String getNomeFile()
  {
    return nomeFile;
  }

  public void setNomeFile(String nomeFile)
  {
    this.nomeFile = nomeFile;
  }

  public String getEstensione()
  {
    return estensione;
  }

  public void setEstensione(String estensione)
  {
    this.estensione = estensione;
  }

}
