/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.indirizzo;

import it.laitspa.cpf.model.Entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_INDI")
public class IndirizzoSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_indi_gen", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_indi_gen", sequenceName = "SEQ_SAN_CPF_SOGEI_INDI",
      allocationSize = 1)
  @Column(name = "CODI_INDI", nullable = false)
  private Integer           codice;
  @Column(name = "DESC_INDI", nullable = false, length = 60)
  private String            indirizzo;
  @Column(name = "DESC_NUME_CIVI", length = 8)
  private String            numeroCivico;
  @Column(name = "DESC_CAP", length = 10, nullable = false)
  private String            cap;
  @Column(name = "DESC_COMU", length = 60, nullable = false)
  private String            comune;
  @Column(name = "DESC_PROV", length = 2)
  private String            provincia;
  @Column(name = "DESC_NAZI", length = 2, nullable = false)
  private String            nazione;
  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_CREA")
  private Date              dataCreazione = new Date();

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getIndirizzo()
  {
    return indirizzo;
  }

  public void setIndirizzo(String indirizzo)
  {
    this.indirizzo = indirizzo;
  }

  public String getNumeroCivico()
  {
    return numeroCivico;
  }

  public void setNumeroCivico(String numeroCivico)
  {
    this.numeroCivico = numeroCivico;
  }

  public String getCap()
  {
    return cap;
  }

  public void setCap(String cap)
  {
    this.cap = cap;
  }

  public String getComune()
  {
    return comune;
  }

  public void setComune(String comune)
  {
    this.comune = comune;
  }

  public String getProvincia()
  {
    return provincia;
  }

  public void setProvincia(String provincia)
  {
    this.provincia = provincia;
  }

  public String getNazione()
  {
    return nazione;
  }

  public void setNazione(String nazione)
  {
    this.nazione = nazione;
  }

  public Date getDataCreazione()
  {
    return dataCreazione;
  }

  public void setDataCreazione(Date dataCreazione)
  {
    this.dataCreazione = dataCreazione;
  }

}
