/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.fattura;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.hibernate.Query;
import org.hibernate.Session;

import it.laitspa.cpf.model.DAO;
import it.laitspa.cpf.model.sogei.statofattura.StatoFatturaSogei;

/**
 * @author andrea
 * 
 */
public class FatturaSogeiDAO
  extends DAO
{

  public FatturaSogeiDAO(Session session)
  {
    super(session);
  }

  public FatturaSogei retrieveFattura(String numeroFattura, Date dataFattura, Integer codiceTipo,
      String nazione, String codiceIdentificativoFiscale)
  {
    String hql =
        "select f "
            + "from FatturaSogei f " + "inner join f.datiTrasmissione dt "
            + "inner join dt.cedente cd " + "inner join cd.anagrafica a "
            + "where upper(f.numeroFattura) = :numeroFattura " + "and year(f.dataFattura) = :year "
            + "and f.tipoFattura.codice = :codiceTipo " + "and a.nazione = :nazione "
            + "and a.codiceIdentificativoFiscale = :codiceIdentificativoFiscale "
            + "and f.stato.codice not in (:statoScartata, :statoDecorrenzaTermini) ";

    GregorianCalendar gc = new GregorianCalendar();
    gc.setTime(dataFattura);
    int year = gc.get(Calendar.YEAR);

    Query q = session.createQuery(hql);
    q.setMaxResults(1);
    q.setParameter("numeroFattura", numeroFattura.toUpperCase());
    q.setParameter("year", year);
    q.setParameter("codiceTipo", codiceTipo);
    q.setParameter("nazione", nazione);
    q.setParameter("codiceIdentificativoFiscale", codiceIdentificativoFiscale);
    q.setParameter("statoScartata", StatoFatturaSogei.SCARTATA);
    q.setParameter("statoDecorrenzaTermini", StatoFatturaSogei.DECORRENZA_TERMINI);

    FatturaSogei result = (FatturaSogei)q.uniqueResult();
    logger.info("retrieveFattura returned " + result);
    return result;
  }

  public boolean
      isSoggettoPresentInTransmission(Integer codiceSoggetto, Integer codiceTrasmissione)
  {
    String hql =
        "select count(*) "
            + "from TrasmissioneSogei s "
            + "left join s.soggettoCedente sced "
            + "left join s.soggettoCessionario scess "
            + "where s.codice = :codiceTrasmissione "
            + "and ( (sced.codice is not null and sced.codice = :codiceSoggetto) or (scess.codice is not null and scess.codice = :codiceSoggetto) ) ";

    Query q = session.createQuery(hql);
    q.setParameter("codiceSoggetto", codiceSoggetto);
    q.setParameter("codiceTrasmissione", codiceTrasmissione);

    Long count = (Long)q.uniqueResult();
    boolean result = count.intValue() > 0;
    logger.info("isSoggettoPresentInTransmission returned " + result);
    return result;
  }

  public FatturaSogei retrieveFatturaByNumero(String numeroFattura, Integer codiceTipo) {
    String hql = "select f " +
                 " from FatturaSogei f " +
                 " where upper(f.numeroFattura) = :numeroFattura " +
                 " and f.tipoFattura.codice = :codiceTipo " +
                 " and f.stato in (:statoRicevuto,:statoDecorrenza)";
    Query q = session.createQuery(hql);

    q.setParameter("numeroFattura", numeroFattura.toUpperCase());
    q.setParameter("codiceTipo", codiceTipo);
    q.setParameter("statoRicevuto", (StatoFatturaSogei)session.load(StatoFatturaSogei.class,StatoFatturaSogei.RICEVUTA));
    q.setParameter("statoDecorrenza", (StatoFatturaSogei)session.load(StatoFatturaSogei.class,StatoFatturaSogei.DECORRENZA_TERMINI));
    return (FatturaSogei)q.uniqueResult();
  }


}
