/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.fattura;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.inviofilesdi.InvioFileSdiSogei;
import it.laitspa.cpf.model.sogei.statofattura.StatoFatturaSogei;
import it.laitspa.cpf.model.sogei.tipofattura.TipoFatturaSogei;
import it.laitspa.cpf.model.sogei.trasmissione.TrasmissioneSogei;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_FATTURA")
public class FatturaSogei
  extends Entity
{
  /**
   * 
   */
  private static final long    serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_fatt_gen", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_fatt_gen", sequenceName = "SEQ_SAN_CPF_SOGEI_FATTURA",
      allocationSize = 1)
  @Column(name = "CODI_FATT_SOGE", nullable = false)
  private Integer              codice;

  @Column(name = "DESC_NUME", nullable = false)
  private String               numeroFattura;

  @Column(name = "NUME_POSI")
  private BigInteger           posizioneFattura;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_FATT", nullable = false)
  private Date                 dataFattura;

  @ManyToOne(targetEntity = InvioFileSdiSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_INVI", nullable = false)
  private InvioFileSdiSogei    invio;

  @ManyToOne(targetEntity = StatoFatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_STAT")
  private StatoFatturaSogei    stato;

  @OneToOne(targetEntity = AllegatoFatturaSogei.class, mappedBy = "fattura", fetch = FetchType.LAZY)
  private AllegatoFatturaSogei allegato;

  @ManyToOne(targetEntity = TipoFatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO", nullable = false)
  private TipoFatturaSogei     tipoFattura;

  @Column(name = "DESC_NUME_BOLL")
  private String               numeroBollo;

  @Column(name = "NUME_IMPT_BOLL")
  private BigDecimal           importoBollo;

  @Column(name = "NUME_IMPT_TOTA")
  private BigDecimal           importoTotale;

  @Column(name = "NUME_IMPT_ARRO")
  private BigDecimal           importoArrotondamento;

  @Column(name = "DESC_CAUS", length=200)
  private String               causale;

  @Type(type = "yes_no")
  @Column(name = "FLAG_AR73")
  private Boolean              flagArt73;

  @Column(name = "DESC_RIFE_NORM", length = 100)
  private String               normativaRiferimento;

  @Column(name = "NUME_FATT_PRIN", length = 20)
  private String               numeroFatturaPrincipale;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_FATT_PRIN")
  private Date                 dataFatturaPrincipale;
  
  @Column(name = "DESC_PERC_VEIC", length = 15)
  private String               totalePercorso;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_VEIC")
  private Date                 dataImmatricolazioneVeicolo;
  
  @ManyToOne(targetEntity=TrasmissioneSogei.class, fetch=FetchType.LAZY)
  @JoinColumn(name="CODI_TRAS")
  private TrasmissioneSogei    datiTrasmissione;
  
  @Column(name = "CODI_DIVI", length=3)
  private String               divisa;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getNumeroFattura()
  {
    return numeroFattura;
  }

  public void setNumeroFattura(String numeroFattura)
  {
    this.numeroFattura = numeroFattura;
  }

  public BigInteger getPosizioneFattura()
  {
    return posizioneFattura;
  }

  public void setPosizioneFattura(BigInteger posizioneFattura)
  {
    this.posizioneFattura = posizioneFattura;
  }

  public Date getDataFattura()
  {
    return dataFattura;
  }

  public void setDataFattura(Date dataFattura)
  {
    this.dataFattura = dataFattura;
  }

  public InvioFileSdiSogei getInvio()
  {
    return invio;
  }

  public void setInvio(InvioFileSdiSogei invio)
  {
    this.invio = invio;
  }

  public StatoFatturaSogei getStato()
  {
    return stato;
  }

  public void setStato(StatoFatturaSogei stato)
  {
    this.stato = stato;
  }

  public AllegatoFatturaSogei getAllegato()
  {
    return allegato;
  }

  public void setAllegato(AllegatoFatturaSogei allegato)
  {
    this.allegato = allegato;
  }

  public TipoFatturaSogei getTipoFattura()
  {
    return tipoFattura;
  }

  public void setTipoFattura(TipoFatturaSogei tipoFattura)
  {
    this.tipoFattura = tipoFattura;
  }

  public String getNumeroBollo()
  {
    return numeroBollo;
  }

  public void setNumeroBollo(String numeroBollo)
  {
    this.numeroBollo = numeroBollo;
  }

  public BigDecimal getImportoBollo()
  {
    return importoBollo;
  }

  public void setImportoBollo(BigDecimal importoBollo)
  {
    this.importoBollo = importoBollo;
  }

  public BigDecimal getImportoTotale()
  {
    return importoTotale;
  }

  public void setImportoTotale(BigDecimal importoTotale)
  {
    this.importoTotale = importoTotale;
  }

  public BigDecimal getImportoArrotondamento()
  {
    return importoArrotondamento;
  }

  public void setImportoArrotondamento(BigDecimal importoArrotondamento)
  {
    this.importoArrotondamento = importoArrotondamento;
  }

  public String getCausale()
  {
    return causale;
  }

  public void setCausale(String causale)
  {
    this.causale = causale;
  }

  public Boolean getFlagArt73()
  {
    return flagArt73;
  }

  public void setFlagArt73(Boolean flagArt73)
  {
    this.flagArt73 = flagArt73;
  }

  public String getNormativaRiferimento()
  {
    return normativaRiferimento;
  }

  public void setNormativaRiferimento(String normativaRiferimento)
  {
    this.normativaRiferimento = normativaRiferimento;
  }

  public String getNumeroFatturaPrincipale()
  {
    return numeroFatturaPrincipale;
  }

  public void setNumeroFatturaPrincipale(String numeroFatturaPrincipale)
  {
    this.numeroFatturaPrincipale = numeroFatturaPrincipale;
  }

  public Date getDataFatturaPrincipale()
  {
    return dataFatturaPrincipale;
  }

  public void setDataFatturaPrincipale(Date dataFatturaPrincipale)
  {
    this.dataFatturaPrincipale = dataFatturaPrincipale;
  }

  public String getTotalePercorso()
  {
    return totalePercorso;
  }

  public void setTotalePercorso(String totalePercorso)
  {
    this.totalePercorso = totalePercorso;
  }

  public Date getDataImmatricolazioneVeicolo()
  {
    return dataImmatricolazioneVeicolo;
  }

  public void setDataImmatricolazioneVeicolo(Date dataImmatricolazioneVeicolo)
  {
    this.dataImmatricolazioneVeicolo = dataImmatricolazioneVeicolo;
  }

  public TrasmissioneSogei getDatiTrasmissione()
  {
    return datiTrasmissione;
  }

  public void setDatiTrasmissione(TrasmissioneSogei datiTrasmissione)
  {
    this.datiTrasmissione = datiTrasmissione;
  }

  public String getDivisa()
  {
    return divisa;
  }

  public void setDivisa(String divisa)
  {
    this.divisa = divisa;
  }

}
