/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.evento;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.inviofilesdi.InvioFileSdiSogei;
import it.laitspa.cpf.model.sogei.statoinvio.StatoInvioSogei;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_EVEN")
public class EventoSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "gene_even_sdi", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "gene_even_sdi", sequenceName = "SEQ_SAN_CPF_SOGEI_EVEN",
      allocationSize = 1)
  @Column(name = "CODI_EVEN")
  private Integer           codice;

  @Column(name = "DESC_EVEN", nullable = false, length = 255)
  private String            descrizione;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_EVEN", nullable = false)
  private Date              data             = new Date();

  @ManyToOne(targetEntity = FatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_FATT_SOGE")
  private FatturaSogei      fattura;

  @ManyToOne(targetEntity = InvioFileSdiSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_INVI")
  private InvioFileSdiSogei invio;

  @ManyToOne(targetEntity = StatoInvioSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_STAT")
  private StatoInvioSogei   statoLotto;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getDescrizione()
  {
    return descrizione;
  }

  public void setDescrizione(String descrizione)
  {
    this.descrizione = descrizione;
  }

  public Date getData()
  {
    return data;
  }

  public void setData(Date data)
  {
    this.data = data;
  }

  public FatturaSogei getFattura()
  {
    return fattura;
  }

  public void setFattura(FatturaSogei fattura)
  {
    this.fattura = fattura;
  }

  public InvioFileSdiSogei getInvio()
  {
    return invio;
  }

  public void setInvio(InvioFileSdiSogei invio)
  {
    this.invio = invio;
  }

  public StatoInvioSogei getStatoLotto()
  {
    return statoLotto;
  }

  public void setStatoLotto(StatoInvioSogei statoLotto)
  {
    this.statoLotto = statoLotto;
  }

}
