/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.datogestionale;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.riga.RigaFatturaSogei;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_RIGA_GEST")
public class DatoGestionaleSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen_gstrig", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen_gstrig", sequenceName = "SEQ_SAN_CPF_SOGEI_RIGA_GEST",
      allocationSize = 1)
  @Column(name = "CODI_DATI_GEST", nullable = false)
  private Integer           codice;

  @Column(name = "DESC_TIPO_DATO", length = 10, nullable = false)
  private String            codiceTipoDato;

  @Column(name = "DESC_RIFE_TEXT", length = 60)
  private String            riferimentoTestuale;

  @Column(name = "NUME_RIFE")
  private BigDecimal        riferimentoNumerico;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_RIFE")
  private Date              riferimentoTemporale;

  @ManyToOne(targetEntity = RigaFatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_RIGA_SOGE", nullable = false)
  private RigaFatturaSogei  riga;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getCodiceTipoDato()
  {
    return codiceTipoDato;
  }

  public void setCodiceTipoDato(String codiceTipoDato)
  {
    this.codiceTipoDato = codiceTipoDato;
  }

  public String getRiferimentoTestuale()
  {
    return riferimentoTestuale;
  }

  public void setRiferimentoTestuale(String riferimentoTestuale)
  {
    this.riferimentoTestuale = riferimentoTestuale;
  }

  public BigDecimal getRiferimentoNumerico()
  {
    return riferimentoNumerico;
  }

  public void setRiferimentoNumerico(BigDecimal riferimentoNumerico)
  {
    this.riferimentoNumerico = riferimentoNumerico;
  }

  public Date getRiferimentoTemporale()
  {
    return riferimentoTemporale;
  }

  public void setRiferimentoTemporale(Date riferimentoTemporale)
  {
    this.riferimentoTemporale = riferimentoTemporale;
  }

  public RigaFatturaSogei getRiga()
  {
    return riga;
  }

  public void setRiga(RigaFatturaSogei riga)
  {
    this.riga = riga;
  }

 
}
