/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.condizionepagamento;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_FATT_PAGA")
public class CondizionePagamentoSogei
  extends Entity
{
  /**
   * 
   */
  private static final long            serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen_cndp", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen_cndp", sequenceName = "SEQ_SAN_CPF_SOGEI_FATT_PAGA",
      allocationSize = 1)
  @Column(name = "CODI_PAGA", nullable = false)
  private Integer                      codice;

  @Column(name = "DESC_BENE", length = 200)
  private String                       beneficiario;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_RIFE_PAGA")
  private Date                         dataRiferimentoTerminiPagamento;

  @Column(name = "NUME_GIOR_PAGA")
  private Integer                      numeroGiorniPagamento;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_SCAD_PAGA")
  private Date                         dataScadenzaTerminiPagamento;

  @Column(name = "NUME_IMPT_PAGA", nullable = false)
  private BigDecimal                   importoPagamento;

  @Column(name = "DESC_UFFI_POST", length = 20)
  private String                       codiceUfficioPostale;

  @Column(name = "DESC_COGN_QUIE", length = 60)
  private String                       cognomeQuietanzante;

  @Column(name = "DESC_NOME_QUIE", length = 60)
  private String                       nomeQuietanzante;

  @Column(name = "DESC_FISC_QUIE", length = 60)
  private String                       codicefiscaleQuietanzante;

  @Column(name = "DESC_TITO_QUIE", length = 60)
  private String                       titoloQuietanzante;

  @Column(name = "DESC_ISTI_FINA", length = 60)
  private String                       istitutoFinanziario;

  @Column(name = "DESC_IBAN", length = 35)
  private String                       codiceIban;

  @Column(name = "DESC_AABI", length = 5)
  private String                       codiceAbi;

  @Column(name = "DESC_CCAB", length = 5)
  private String                       codiceCab;

  @Column(name = "DESC_BBIC", length = 5)
  private String                       codiceBic;

  @Column(name = "NUME_SCNT_PAGA")
  private BigDecimal                   importoScontoPagamentoAnticipato;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_LIMI_PAGA")
  private Date                         dataLimiteScontoPagamentoAnticipato;

  @Column(name = "NUME_IMPT_PENA_RITA")
  private BigDecimal                   importoPenalePagamentoRitardato;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_PENA")
  private Date                         dataDecorrenzaPenale;

  @Column(name = "DESC_CODI_PAGA", length = 15)
  private String                       codicePagamento;

  @ManyToOne(targetEntity = TipoModalitaPagamentoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_MODL", nullable = false)
  private TipoModalitaPagamentoSogei   tipoModalitaPagamento;

  @ManyToOne(targetEntity = TipoCondizioniPagamentoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_COND", nullable = false)
  private TipoCondizioniPagamentoSogei tipoCondizionePagamento;

  @ManyToOne(targetEntity = FatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_FATT_SOGE", nullable = false)
  private FatturaSogei                 fattura;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getBeneficiario()
  {
    return beneficiario;
  }

  public void setBeneficiario(String beneficiario)
  {
    this.beneficiario = beneficiario;
  }

  public Date getDataRiferimentoTerminiPagamento()
  {
    return dataRiferimentoTerminiPagamento;
  }

  public void setDataRiferimentoTerminiPagamento(Date dataRiferimentoTerminiPagamento)
  {
    this.dataRiferimentoTerminiPagamento = dataRiferimentoTerminiPagamento;
  }

  public Integer getNumeroGiorniPagamento()
  {
    return numeroGiorniPagamento;
  }

  public void setNumeroGiorniPagamento(Integer numeroGiorniPagamento)
  {
    this.numeroGiorniPagamento = numeroGiorniPagamento;
  }

  public Date getDataScadenzaTerminiPagamento()
  {
    return dataScadenzaTerminiPagamento;
  }

  public void setDataScadenzaTerminiPagamento(Date dataScadenzaTerminiPagamento)
  {
    this.dataScadenzaTerminiPagamento = dataScadenzaTerminiPagamento;
  }

  public BigDecimal getImportoPagamento()
  {
    return importoPagamento;
  }

  public void setImportoPagamento(BigDecimal importoPagamento)
  {
    this.importoPagamento = importoPagamento;
  }

  public String getCodiceUfficioPostale()
  {
    return codiceUfficioPostale;
  }

  public void setCodiceUfficioPostale(String codiceUfficioPostale)
  {
    this.codiceUfficioPostale = codiceUfficioPostale;
  }

  public String getCognomeQuietanzante()
  {
    return cognomeQuietanzante;
  }

  public void setCognomeQuietanzante(String cognomeQuietanzante)
  {
    this.cognomeQuietanzante = cognomeQuietanzante;
  }

  public String getNomeQuietanzante()
  {
    return nomeQuietanzante;
  }

  public void setNomeQuietanzante(String nomeQuietanzante)
  {
    this.nomeQuietanzante = nomeQuietanzante;
  }

  public String getCodicefiscaleQuietanzante()
  {
    return codicefiscaleQuietanzante;
  }

  public void setCodicefiscaleQuietanzante(String codicefiscaleQuietanzante)
  {
    this.codicefiscaleQuietanzante = codicefiscaleQuietanzante;
  }

  public String getTitoloQuietanzante()
  {
    return titoloQuietanzante;
  }

  public void setTitoloQuietanzante(String titoloQuietanzante)
  {
    this.titoloQuietanzante = titoloQuietanzante;
  }

  public String getIstitutoFinanziario()
  {
    return istitutoFinanziario;
  }

  public void setIstitutoFinanziario(String istitutoFinanziario)
  {
    this.istitutoFinanziario = istitutoFinanziario;
  }

  public String getCodiceIban()
  {
    return codiceIban;
  }

  public void setCodiceIban(String codiceIban)
  {
    this.codiceIban = codiceIban;
  }

  public String getCodiceAbi()
  {
    return codiceAbi;
  }

  public void setCodiceAbi(String codiceAbi)
  {
    this.codiceAbi = codiceAbi;
  }

  public String getCodiceCab()
  {
    return codiceCab;
  }

  public void setCodiceCab(String codiceCab)
  {
    this.codiceCab = codiceCab;
  }

  public String getCodiceBic()
  {
    return codiceBic;
  }

  public void setCodiceBic(String codiceBic)
  {
    this.codiceBic = codiceBic;
  }

  public BigDecimal getImportoScontoPagamentoAnticipato()
  {
    return importoScontoPagamentoAnticipato;
  }

  public void setImportoScontoPagamentoAnticipato(BigDecimal importoScontoPagamentoAnticipato)
  {
    this.importoScontoPagamentoAnticipato = importoScontoPagamentoAnticipato;
  }

  public Date getDataLimiteScontoPagamentoAnticipato()
  {
    return dataLimiteScontoPagamentoAnticipato;
  }

  public void setDataLimiteScontoPagamentoAnticipato(Date dataLimiteScontoPagamentoAnticipato)
  {
    this.dataLimiteScontoPagamentoAnticipato = dataLimiteScontoPagamentoAnticipato;
  }

  public BigDecimal getImportoPenalePagamentoRitardato()
  {
    return importoPenalePagamentoRitardato;
  }

  public void setImportoPenalePagamentoRitardato(BigDecimal importoPenalePagamentoRitardato)
  {
    this.importoPenalePagamentoRitardato = importoPenalePagamentoRitardato;
  }

  public Date getDataDecorrenzaPenale()
  {
    return dataDecorrenzaPenale;
  }

  public void setDataDecorrenzaPenale(Date dataDecorrenzaPenale)
  {
    this.dataDecorrenzaPenale = dataDecorrenzaPenale;
  }

  public String getCodicePagamento()
  {
    return codicePagamento;
  }

  public void setCodicePagamento(String codicePagamento)
  {
    this.codicePagamento = codicePagamento;
  }

  public TipoModalitaPagamentoSogei getTipoModalitaPagamento()
  {
    return tipoModalitaPagamento;
  }

  public void setTipoModalitaPagamento(TipoModalitaPagamentoSogei tipoModalitaPagamento)
  {
    this.tipoModalitaPagamento = tipoModalitaPagamento;
  }

  public TipoCondizioniPagamentoSogei getTipoCondizionePagamento()
  {
    return tipoCondizionePagamento;
  }

  public void setTipoCondizionePagamento(TipoCondizioniPagamentoSogei tipoCondizionePagamento)
  {
    this.tipoCondizionePagamento = tipoCondizionePagamento;
  }

  public FatturaSogei getFattura()
  {
    return fattura;
  }

  public void setFattura(FatturaSogei fattura)
  {
    this.fattura = fattura;
  }

}
