/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.cessionariocommittente;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.anagrafica.AnagraficaSogei;
import it.laitspa.cpf.model.sogei.indirizzo.IndirizzoSogei;
import it.laitspa.cpf.model.sogei.trasmissione.TrasmissioneSogei;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_CESS_FATT")
public class CessionarioCommittenteSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen07", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen07", sequenceName = "SEQ_SAN_CPF_SOGEI_CESS_FATT",
      allocationSize = 1)
  @Column(name = "CODI_CESS", nullable = false)
  private Integer           codice;

  @ManyToOne(targetEntity = AnagraficaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_ANAG", nullable = false)
  @Cascade(CascadeType.SAVE_UPDATE)
  private AnagraficaSogei   anagrafica;

  @ManyToOne(targetEntity = IndirizzoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_INDI_SEDE", nullable = false)
  private IndirizzoSogei    indirizzoSede;

  @ManyToOne(targetEntity = TrasmissioneSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TRAS", nullable = false)
  private TrasmissioneSogei trasmissione;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public AnagraficaSogei getAnagrafica()
  {
    return anagrafica;
  }

  public void setAnagrafica(AnagraficaSogei anagrafica)
  {
    this.anagrafica = anagrafica;
  }

  public IndirizzoSogei getIndirizzoSede()
  {
    return indirizzoSede;
  }

  public void setIndirizzoSede(IndirizzoSogei indirizzoSede)
  {
    this.indirizzoSede = indirizzoSede;
  }

  public TrasmissioneSogei getTrasmissione()
  {
    return trasmissione;
  }

  public void setTrasmissione(TrasmissioneSogei trasmissione)
  {
    this.trasmissione = trasmissione;
  }

}
