/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.cedente;

import it.laitspa.cpf.model.Entity;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_CEDE_REEA")
public class IscrizioneReaSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen04", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen04", sequenceName = "SEQ_SAN_CPF_SOGEI_CEDE_REEA",
      allocationSize = 1)
  @Column(name = "CODI_REEA", nullable = false)
  private Integer           codice;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_CREA", nullable = false)
  private Date              dataCreazione = new Date();

  @Column(name = "DESC_UFFI", length = 2, nullable = false)
  private String            ufficio;

  @Column(name = "DESC_NUME_REEA", length = 20, nullable = false)
  private String            numeroRea;

  @Column(name = "NUME_IMPT_SOCI")
  private BigDecimal        importoCapitaleSociale;

  @Column(name = "DESC_CODI_SOCI", length = 2)
  private String            descrizioneCodiceSoci;

  @Column(name = "DESC_STAT_LIQU", length = 2)
  private String            descrizioneStatoLiquidazione;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public Date getDataCreazione()
  {
    return dataCreazione;
  }

  public void setDataCreazione(Date dataCreazione)
  {
    this.dataCreazione = dataCreazione;
  }

  public String getUfficio()
  {
    return ufficio;
  }

  public void setUfficio(String ufficio)
  {
    this.ufficio = ufficio;
  }

  public String getNumeroRea()
  {
    return numeroRea;
  }

  public void setNumeroRea(String numeroRea)
  {
    this.numeroRea = numeroRea;
  }

  public BigDecimal getImportoCapitaleSociale()
  {
    return importoCapitaleSociale;
  }

  public void setImportoCapitaleSociale(BigDecimal importoCapitaleSociale)
  {
    this.importoCapitaleSociale = importoCapitaleSociale;
  }

  public String getDescrizioneCodiceSoci()
  {
    return descrizioneCodiceSoci;
  }

  public void setDescrizioneCodiceSoci(String descrizioneCodiceSoci)
  {
    this.descrizioneCodiceSoci = descrizioneCodiceSoci;
  }

  public String getDescrizioneStatoLiquidazione()
  {
    return descrizioneStatoLiquidazione;
  }

  public void setDescrizioneStatoLiquidazione(String descrizioneStatoLiquidazione)
  {
    this.descrizioneStatoLiquidazione = descrizioneStatoLiquidazione;
  }

}
