/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.cedente;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.anagrafica.AnagraficaSogei;
import it.laitspa.cpf.model.sogei.contatto.ContattoSogei;
import it.laitspa.cpf.model.sogei.indirizzo.IndirizzoSogei;
import it.laitspa.cpf.model.sogei.regimefiscale.TipoRegimeFiscaleSogei;
import it.laitspa.cpf.model.sogei.trasmissione.TrasmissioneSogei;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_CEDE_FATT")
public class CedentePrestatoreSogei
  extends Entity
{
  /**
   * 
   */
  private static final long      serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen06", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen06", sequenceName = "SEQ_SAN_CPF_SOGEI_CEDE_FATT",
      allocationSize = 1)
  @Column(name = "CODI_CEDE", nullable = false)
  private Integer                codice;

  @ManyToOne(targetEntity = AnagraficaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_ANAG", nullable = false)
  @Cascade(CascadeType.SAVE_UPDATE)
  private AnagraficaSogei        anagrafica;

  @ManyToOne(targetEntity = AnagraficaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_RAPP")
  @Cascade(CascadeType.SAVE_UPDATE)
  private AnagraficaSogei        rappresentanteFiscale;

  @ManyToOne(targetEntity = AnagraficaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_INTE")
  @Cascade(CascadeType.SAVE_UPDATE)
  private AnagraficaSogei        intermediario;

  @Column(name = "DESC_ALBO", length = 60)
  private String                 descrizioneAlbo;
  @Column(name = "DESC_PROV_ALBO", length = 2)
  private String                 provinciaAlbo;
  @Column(name = "DESC_NUME_ALBO", length = 60)
  private String                 descrizioneNumeroIscrizioneAlbo;

  @Temporal(TemporalType.DATE)
  @Column(name = "DATA_ALBO")
  private Date                   dataIscrizioneAlbo;

  @ManyToOne(targetEntity = TipoRegimeFiscaleSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_REGI")
  private TipoRegimeFiscaleSogei regimeFiscale;

  @ManyToOne(targetEntity = IndirizzoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_INDI_SEDE", nullable = false)
  private IndirizzoSogei         indirizzoSede;

  @ManyToOne(targetEntity = IndirizzoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_INDI_STAB")
  private IndirizzoSogei         indirizzoStabile;

  @ManyToOne(targetEntity = IscrizioneReaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_REEA")
  private IscrizioneReaSogei     iscrizioneRea;

  @ManyToOne(targetEntity = ContattoSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_CONT")
  private ContattoSogei          contatto;

  @Column(name = "DESC_RIFE_AMMI", length = 20)
  private String                 riferimentoAmministrazione;

  @ManyToOne(targetEntity = TrasmissioneSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TRAS", nullable = false)
  private TrasmissioneSogei      trasmissione;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public AnagraficaSogei getAnagrafica()
  {
    return anagrafica;
  }

  public void setAnagrafica(AnagraficaSogei anagrafica)
  {
    this.anagrafica = anagrafica;
  }

  public AnagraficaSogei getRappresentanteFiscale()
  {
    return rappresentanteFiscale;
  }

  public void setRappresentanteFiscale(AnagraficaSogei rappresentanteFiscale)
  {
    this.rappresentanteFiscale = rappresentanteFiscale;
  }

  public AnagraficaSogei getIntermediario()
  {
    return intermediario;
  }

  public void setIntermediario(AnagraficaSogei intermediario)
  {
    this.intermediario = intermediario;
  }

  public String getDescrizioneAlbo()
  {
    return descrizioneAlbo;
  }

  public void setDescrizioneAlbo(String descrizioneAlbo)
  {
    this.descrizioneAlbo = descrizioneAlbo;
  }

  public String getProvinciaAlbo()
  {
    return provinciaAlbo;
  }

  public void setProvinciaAlbo(String provinciaAlbo)
  {
    this.provinciaAlbo = provinciaAlbo;
  }

  public String getDescrizioneNumeroIscrizioneAlbo()
  {
    return descrizioneNumeroIscrizioneAlbo;
  }

  public void setDescrizioneNumeroIscrizioneAlbo(String descrizioneNumeroIscrizioneAlbo)
  {
    this.descrizioneNumeroIscrizioneAlbo = descrizioneNumeroIscrizioneAlbo;
  }

  public Date getDataIscrizioneAlbo()
  {
    return dataIscrizioneAlbo;
  }

  public void setDataIscrizioneAlbo(Date dataIscrizioneAlbo)
  {
    this.dataIscrizioneAlbo = dataIscrizioneAlbo;
  }

  public TipoRegimeFiscaleSogei getRegimeFiscale()
  {
    return regimeFiscale;
  }

  public void setRegimeFiscale(TipoRegimeFiscaleSogei regimeFiscale)
  {
    this.regimeFiscale = regimeFiscale;
  }

  public IndirizzoSogei getIndirizzoSede()
  {
    return indirizzoSede;
  }

  public void setIndirizzoSede(IndirizzoSogei indirizzoSede)
  {
    this.indirizzoSede = indirizzoSede;
  }

  public IndirizzoSogei getIndirizzoStabile()
  {
    return indirizzoStabile;
  }

  public void setIndirizzoStabile(IndirizzoSogei indirizzoStabile)
  {
    this.indirizzoStabile = indirizzoStabile;
  }

  public IscrizioneReaSogei getIscrizioneRea()
  {
    return iscrizioneRea;
  }

  public void setIscrizioneRea(IscrizioneReaSogei iscrizioneRea)
  {
    this.iscrizioneRea = iscrizioneRea;
  }

  public ContattoSogei getContatto()
  {
    return contatto;
  }

  public void setContatto(ContattoSogei contatto)
  {
    this.contatto = contatto;
  }

  public String getRiferimentoAmministrazione()
  {
    return riferimentoAmministrazione;
  }

  public void setRiferimentoAmministrazione(String riferimentoAmministrazione)
  {
    this.riferimentoAmministrazione = riferimentoAmministrazione;
  }

  public TrasmissioneSogei getTrasmissione()
  {
    return trasmissione;
  }

  public void setTrasmissione(TrasmissioneSogei trasmissione)
  {
    this.trasmissione = trasmissione;
  }

}
