/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.cassaprevidenziale;

import it.laitspa.cpf.model.Entity;
import it.laitspa.cpf.model.sogei.fattura.FatturaSogei;
import it.laitspa.cpf.model.sogei.tipocassaprevidenziale.TipoCassaPrevidenzialeSogei;
import it.laitspa.cpf.model.sogei.tiponatura.TipoNaturaSogei;

import java.math.BigDecimal;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import org.hibernate.annotations.Type;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_FATTCASS")
public class CassaPrevidenzialeSogei
  extends Entity
{
  /**
   * 
   */
  private static final long           serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_csp_gen", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_csp_gen", sequenceName = "SEQ_SAN_CPF_SOGEI_FATTCASS",
      allocationSize = 1)
  @Column(name = "CODI_FATT_CASS", nullable = false)
  private Integer                     codice;

  @Column(name = "DESC_RIFE_AMMI", length = 20)
  private String                      riferimentoAmministrativo;

  @Type(type = "yes_no")
  @Column(name = "FLAG_RITE")
  private Boolean                     flagRitenuta;

  @Column(name = "NUME_IMPT_ALCS", nullable = false)
  private BigDecimal                  importoAliquotaCassa;

  @Column(name = "NUME_IMPT_CNTR", nullable = false)
  private BigDecimal                  importoContributoCassa;

  @Column(name = "NUME_IMPN_CASS")
  private BigDecimal                  importoImponibileCassa;

  @Column(name = "NUME_IMPT_ALIQ", nullable = false)
  private BigDecimal                  importoAliquota;

  @ManyToOne(targetEntity = TipoCassaPrevidenzialeSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_CASS", nullable = false)
  private TipoCassaPrevidenzialeSogei tipoCassa;

  @ManyToOne(targetEntity = TipoNaturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_TIPO_NATU")
  private TipoNaturaSogei             tipoNatura;

  @ManyToOne(targetEntity = FatturaSogei.class, fetch = FetchType.LAZY)
  @JoinColumn(name = "CODI_FATT_SOGE")
  private FatturaSogei                fattura;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public String getRiferimentoAmministrativo()
  {
    return riferimentoAmministrativo;
  }

  public void setRiferimentoAmministrativo(String riferimentoAmministrativo)
  {
    this.riferimentoAmministrativo = riferimentoAmministrativo;
  }

  public Boolean getFlagRitenuta()
  {
    return flagRitenuta;
  }

  public void setFlagRitenuta(Boolean flagRitenuta)
  {
    this.flagRitenuta = flagRitenuta;
  }

  public BigDecimal getImportoAliquotaCassa()
  {
    return importoAliquotaCassa;
  }

  public void setImportoAliquotaCassa(BigDecimal importoAliquotaCassa)
  {
    this.importoAliquotaCassa = importoAliquotaCassa;
  }

  public BigDecimal getImportoContributoCassa()
  {
    return importoContributoCassa;
  }

  public void setImportoContributoCassa(BigDecimal importoContributoCassa)
  {
    this.importoContributoCassa = importoContributoCassa;
  }

  public BigDecimal getImportoImponibileCassa()
  {
    return importoImponibileCassa;
  }

  public void setImportoImponibileCassa(BigDecimal importoImponibileCassa)
  {
    this.importoImponibileCassa = importoImponibileCassa;
  }

  public BigDecimal getImportoAliquota()
  {
    return importoAliquota;
  }

  public void setImportoAliquota(BigDecimal importoAliquota)
  {
    this.importoAliquota = importoAliquota;
  }

  public TipoCassaPrevidenzialeSogei getTipoCassa()
  {
    return tipoCassa;
  }

  public void setTipoCassa(TipoCassaPrevidenzialeSogei tipoCassa)
  {
    this.tipoCassa = tipoCassa;
  }

  public TipoNaturaSogei getTipoNatura()
  {
    return tipoNatura;
  }

  public void setTipoNatura(TipoNaturaSogei tipoNatura)
  {
    this.tipoNatura = tipoNatura;
  }

  public FatturaSogei getFattura()
  {
    return fattura;
  }

  public void setFattura(FatturaSogei fattura)
  {
    this.fattura = fattura;
  }

}
