/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.model.sogei.anagrafica;

import it.laitspa.cpf.model.Entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

/**
 * @author andrea
 * 
 */
@javax.persistence.Entity
@Table(name = "TAB_SAN_CPF_SOGEI_ANAG")
public class AnagraficaSogei
  extends Entity
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Id
  @GeneratedValue(generator = "sdi_gen05", strategy = GenerationType.SEQUENCE)
  @SequenceGenerator(name = "sdi_gen05", sequenceName = "SEQ_SAN_CPF_SOGEI_ANAG",
      allocationSize = 1)
  @Column(name = "CODI_ANAG", nullable = false)
  private Integer           codice;

  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "DATA_CREA", nullable = false)
  private Date              dataCreazione = new Date();

  @Column(name = "DESC_NAZI")
  private String            nazione;

  @Column(name = "DESC_IDEN_FISC", length = 50)
  private String            codiceIdentificativoFiscale;

  @Column(name = "DESC_CODI_FISC", length = 50)
  private String            codiceFiscale;

  @Column(name = "DESC_DENO", length = 80)
  private String            denominazione;
  @Column(name = "DESC_NOME", length = 60)
  private String            nome;
  @Column(name = "DESC_COGN", length = 60)
  private String            cognome;
  @Column(name = "DESC_TITO", length = 10)
  private String            descrizioneTitolare;

  @Column(name = "DESC_EORI", length = 17)
  private String            descrizioneCodiceEori;

  public Integer getCodice()
  {
    return codice;
  }

  public void setCodice(Integer codice)
  {
    this.codice = codice;
  }

  public Date getDataCreazione()
  {
    return dataCreazione;
  }

  public void setDataCreazione(Date dataCreazione)
  {
    this.dataCreazione = dataCreazione;
  }

  public String getNazione()
  {
    return nazione;
  }

  public void setNazione(String nazione)
  {
    this.nazione = nazione;
  }

  public String getCodiceIdentificativoFiscale()
  {
    return codiceIdentificativoFiscale;
  }

  public void setCodiceIdentificativoFiscale(String codiceIdentificativoFiscale)
  {
    this.codiceIdentificativoFiscale = codiceIdentificativoFiscale;
  }

  public String getCodiceFiscale()
  {
    return codiceFiscale;
  }

  public void setCodiceFiscale(String codiceFiscale)
  {
    this.codiceFiscale = codiceFiscale;
  }

  public String getDenominazione()
  {
    return denominazione;
  }

  public void setDenominazione(String denominazione)
  {
    this.denominazione = denominazione;
  }

  public String getNome()
  {
    return nome;
  }

  public void setNome(String nome)
  {
    this.nome = nome;
  }

  public String getCognome()
  {
    return cognome;
  }

  public void setCognome(String cognome)
  {
    this.cognome = cognome;
  }

  public String getDescrizioneTitolare()
  {
    return descrizioneTitolare;
  }

  public void setDescrizioneTitolare(String descrizioneTitolare)
  {
    this.descrizioneTitolare = descrizioneTitolare;
  }

  public String getDescrizioneCodiceEori()
  {
    return descrizioneCodiceEori;
  }

  public void setDescrizioneCodiceEori(String descrizioneCodiceEori)
  {
    this.descrizioneCodiceEori = descrizioneCodiceEori;
  }
  
  @Transient
  public String getDescrizione()
  {
    String descrizione = (denominazione != null ? denominazione : nome + " " + cognome) + " " + 
        (codiceIdentificativoFiscale != null ? "(" + codiceIdentificativoFiscale + ")": "(" + codiceFiscale + ")");
    return descrizione;
  }

}
