/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.job;

import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public abstract class StatefulConcurrencyJob
  implements StatefulJob
{
  protected Logger logger;

  public StatefulConcurrencyJob()
  {
    logger = Logger.getLogger(this.getClass());
  }

  public abstract boolean isBusy();
  
  public abstract void setBusy(boolean busy);
  

  public abstract void _execute(JobExecutionContext jec)
    throws JobExecutionException;

  public void execute(JobExecutionContext jec)
    throws JobExecutionException
  {
    // Check concurrency
    //
    boolean jobbusy = isBusy();
    if(jobbusy)
    {
      logger.warn("Multiple running detected. Stopping current job invocation.");
      return;
    }

    // Run specialized
    //
    try
    {
      logger.debug("Execute Job.");
      
      // Disable running
      //
      logger.info("Lock Job execution.");
      setBusy(true);
      // Execute Job
      //
      _execute(jec);
      
      // Enable running
      //
      logger.info("Release Job execution.");
      setBusy(false);
    }
    catch (Exception e) {
      logger.info("Release Job execution.");
      setBusy(false);
      logger.error("Exception caught while executing job",e);
      throw new JobExecutionException(e);
    }

  }
}