/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.job;

import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class ConcurrencyJob
  implements Job
{
  protected transient Logger logger;

  public ConcurrencyJob()
  {
    logger = Logger.getLogger(this.getClass());
  }

  public abstract void markJob();
  public abstract void releaseJob();
  public abstract Integer getCurrentNumbers();
  
  
  public abstract void _execute(JobExecutionContext jec)
    throws JobExecutionException;

  public void execute(JobExecutionContext jec)
    throws JobExecutionException
  {
    // Check concurrency
    //
    JobDataMap map = jec.getMergedJobDataMap();
    Integer max_server = map.getIntegerFromString("max_serventi");
    if (max_server == null)
    {
      throw new JobExecutionException("Parameter \"max_serventi\" is required to run a ConcurrencyJob instance.");
    }
    
    // Check current running jobs.
    //
    Integer current_number = getCurrentNumbers();
    if(current_number >= max_server)
    {
      logger.warn("Max running jobs detected. Stopping current job invocation.");
      return;
    }

    // Run specialized
    //
    try
    {
      logger.debug("Execute Job.");
      
      // Register current instance of job.
      //
      markJob();
      logger.info("New Job execution registered.");
      
      // Execute Job
      //
      _execute(jec);
      
      // Enable running
      //
      releaseJob();
      logger.info("Release Job execution.");
    }
    catch (Exception e) {
      logger.info("Release Job execution.");
      releaseJob();
      logger.error("Exception caught while executing job",e);
      throw new JobExecutionException(e);
    }

  }
}