/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.faces.utils;


public class MimeUtils
{
  public static String getMimeType(String fileName)
  {
    int index = fileName.lastIndexOf('.');
    if(index < 0)
      return null;
    
    String ext = fileName.substring(index).trim().toLowerCase();
    
    if(ext.equals(".pdf"))
      return "application/pdf";
    
    else if(ext.equals(".zip"))
      return "application/zip";
    
    else if(ext.equals(".gz"))
      return "application/x-gzip";
    
    else if(ext.equals(".gif"))
      return "image/gif";
    
    else if(ext.equals(".jpg"))
      return "image/jpeg";
    
    else if(ext.equals(".png"))
      return "image/png";
    
    else if(ext.equals(".tif"))
      return "image/tiff";
    
    else if(ext.equals(".csv"))
      return "text/csv";
    
    else if(ext.equals(".html"))
      return "text/html";
    
    else if(ext.equals(".txt"))
      return "text/plain";
    
    else if(ext.equals(".xml"))
      return "text/xml";
    
    else if(ext.equals(".doc"))
      return "application/msword";
    
    else if(ext.equals(".xls"))
      return "application/vnd.ms-excel";
    
    else if(ext.equals(".ppt"))
      return "application/vnd.ms-powerpoint";
    
    else if(ext.equals(".p7m") || ext.equals(".P7M"))
      return "application/pkcs7-mime";
    
    return null;
  }
}
