/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.faces.streaming;

import it.laitspa.cpf.util.log.LogUtils;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class StreamingServlet
  extends HttpServlet
{
    /**
   * 
   */
  private static final long serialVersionUID = 1L;

    @Override
  protected void service(HttpServletRequest req, HttpServletResponse res)
    throws ServletException, IOException
  {
    //Logger
    //
    LogUtils.info(getClass(), "Streaming content.");
    
    // Extract action form from session.
    //
    HttpSession ses = req.getSession();
    StreamingBean saf = (StreamingBean)ses.getAttribute("StreamingBean");
    byte[] data = saf != null ? saf.getData() : null;
    if(data == null)
      return;
    
    
    // Output headers to response stream.
    // if stream is html page headers are already present inside.
    //
    if (saf.getContentType() != null && !saf.getContentType().equalsIgnoreCase("text/html"))
    {
      res.setContentType(saf.getContentType());
      res.setContentLength(data.length);
      if(saf.isInline())
        res.setHeader("Content-Disposition", 
          "inline; filename=\"" + saf.getFileName() + "\"");
      else
        res.setHeader("Content-Disposition", 
          "attachment; filename=\"" + saf.getFileName() + "\"");
    }

    // Output data to response stream.
    //
    ServletOutputStream os = res.getOutputStream();
    try
    {
      os.write(data, 0, data.length);
      os.flush();
    }
    catch (Exception e) {
      LogUtils.error(getClass(), e);
    }
    finally
    {
      /*
      if(os != null)
      {
        try
        {
          os.close();
        }
        catch (IOException ex)
        {
        }
      }
      */
    }
  }
}
