/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package it.laitspa.cpf.faces.streaming;

import it.laitspa.cpf.faces.BeanModel;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

import org.apache.log4j.Logger;

/**
 * 
 * @author Andrea
 */
public class StreamingBean
  extends BeanModel
{

  private static final long       serialVersionUID       = -751236823869037867L;

  private static transient Logger logger;

  public static final String      FORWARD_MESSAGE        = "streaming_content";
  public static final String      DIRECT_FORWARD_MESSAGE = "streaming_content_direct";
  public static final String      STREAMING_SERVLET_PATH =
                                                             "/faces/common/streaming/StreamingServlet";

  private String                  contentType;
  private byte[]                  data;
  private String                  fileName;
  private boolean                 inline;
  private String                  backUrl;

  private boolean                 canDelete;

  static
  {
    logger = Logger.getLogger(StreamingBean.class);
  }

  public boolean isCanDelete()
  {
    return canDelete;
  }

  public void setCanDelete(boolean canDelete)
  {
    this.canDelete = canDelete;
  }

  public String getBackUrl()
  {
    return backUrl;
  }

  public void setBackUrl(String backUrl)
  {
    this.backUrl = backUrl;
  }

  public String getContentType()
  {
    return contentType;
  }

  public void setContentType(String contentType)
  {
    this.contentType = contentType;
  }

  public byte[] getData()
  {
    return data;
  }

  public void setData(byte[] data)
  {
    this.data = data;
  }

  public String getFileName()
  {
    return fileName;
  }

  public void setFileName(String fileName)
  {
    this.fileName = fileName;
  }

  public boolean isInline()
  {
    return inline;
  }

  public void setInline(boolean inline)
  {
    this.inline = inline;
  }

  /** Creates a new instance of StreamingBean */
  public StreamingBean()
  {
    contentType = "application/octet-stream";
    data = null;
    fileName = "";
    inline = false;
    backUrl = "/faces/private/home/index.xhtml";
    canDelete = false;
  }

  public void clean()
  {
    contentType = "application/octet-stream";
    data = null;
    fileName = "";
    inline = false;
    backUrl = "/faces/private/home/index.xhtml";
    canDelete = false;
  }

  public void doCallStreamingServlet()
  {
    FacesContext context = FacesContext.getCurrentInstance();
    try
    {
      context.getExternalContext().dispatch(STREAMING_SERVLET_PATH);
    }
    catch(Exception e)
    {
      logger.error(e);
    }
    finally
    {
      context.responseComplete();
    }
  }

  public void doCallFileStreamingServlet()
  {

    // Obtain contexts.
    //
    FacesContext context = FacesContext.getCurrentInstance();
    ExternalContext externalContext = context.getExternalContext();

    String url = context.getExternalContext().getRequestContextPath();
    url += "/faces/private/FileSystemZipAwareServlet";

    try
    {
      externalContext.redirect(url);
    }
    catch(Exception e)
    {
      logger.error("Exception caught while sending redirect to file system streaming servlet.", e);
    }
    finally
    {
      context.responseComplete();
    }
  }

  public void doCallFileStreamingServlet(boolean unzip)
  {

    // Obtain contexts.
    //
    FacesContext context = FacesContext.getCurrentInstance();
    ExternalContext externalContext = context.getExternalContext();

    String url = context.getExternalContext().getRequestContextPath();
    url += "/faces/private/FileSystemZipAwareServlet";
    url += "?unzip=";
    url += unzip;

    try
    {
      externalContext.redirect(url);
    }
    catch(Exception e)
    {
      logger.error("Exception caught while sending redirect to file system streaming servlet.", e);
    }
    finally
    {
      context.responseComplete();
    }
  }
}
