/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.faces.streaming;

import it.laitspa.cpf.util.log.LogUtils;
import it.laitspa.cpf.util.misc.JndiServiceLocator;

import java.io.FileInputStream;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 
 * @author andrea
 *
 */

public class ResourcesServlet
  extends HttpServlet
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Override
  protected void service(HttpServletRequest req, HttpServletResponse res)
    throws ServletException, IOException
  {
    // Logger
    //
    LogUtils.debug(getClass(), "resources content.");

    // load external context
    //
    String resource = req.getParameter("resource");
    if(resource == null)
      return;

    JndiServiceLocator jl = JndiServiceLocator.getInstance();
    String path = null;
    try
    {
      path = (String)jl.lookup(resource);
    }
    catch(Exception e)
    {
      path = null;
    }

    if(path == null)
      return;

    // Output data to response stream.
    //
    ServletOutputStream os = res.getOutputStream();
    FileInputStream fis = new FileInputStream(path);

    try
    {
      byte[] buffer = new byte[512];
      int len = 0;
      while((len = fis.read(buffer)) != -1)
        os.write(buffer, 0, len);

      os.flush();
    }
    catch(Exception e)
    {
      LogUtils.error(getClass(), e);
    }
    finally
    {
      fis.close();
    }
  }
}
