/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
package it.laitspa.cpf.faces.streaming;

import it.laitspa.cpf.faces.utils.MimeUtils;
import it.laitspa.cpf.util.log.LogUtils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;

import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileSystemServlet
  extends HttpServlet
{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @Override
  protected void service(HttpServletRequest req, HttpServletResponse res)
    throws ServletException,
      IOException
  {
    // Logger
    //
    LogUtils.info(getClass(), "FileSystem content.");

    // Declare output stream.
    //
    BufferedOutputStream bos = null;

    // Declare input stream.
    //
    FileInputStream fis = null;

    try
    {
      InitialContext ctx = new InitialContext();
      URL url = (URL)ctx.lookup("sanfer/fsroot");
      File root = new File(url.toURI());

      // Retrieve request parameter.
      //
      String childPath = req.getParameter("file");
      File child = new File(root, childPath);
      
      // Redirect if resource is not available.
      //
      if (!child.exists())
      {
        LogUtils.error(getClass(), MessageFormat.format("The requested resource on file system {0} does not exists.", new Object[]{childPath}));
        RequestDispatcher dispatcher = req.getRequestDispatcher("/faces/common/error/errorresourcepage.xhtml");
        dispatcher.forward(req, res);
        return;
      }
      
      
      fis = new FileInputStream(child);

      // Set content type.
      //
      String type = MimeUtils.getMimeType(child.getAbsolutePath());
      res.setContentType(type);
      res.setContentLength((int)child.length());
      res.setHeader("Content-Disposition", "attachment; filename=\""
          + child.getName() + "\"");

      // Output data to response stream.
      //
      bos = new BufferedOutputStream(res.getOutputStream(), 16384);
      int c;
      while((c = fis.read()) != -1)
        bos.write(c);
      bos.flush();
    }
    catch(Exception e)
    {
      LogUtils.error(getClass(), e);
    }
    finally
    {
      /*
       * Servlet Output stream: we don't need to close a browser servlet stream!
      if(bos != null)
      {
        try
        {
          bos.close();
          LogUtils.error(getClass(), "Closing stream.");
        }
        catch(IOException ex)
        {
        }
      }
      */

      if(fis != null)
      {
        try
        {
          fis.close();
          LogUtils.error(getClass(), "Closing stream.");
        }
        catch(IOException ex)
        {
        }
      }
    }
  }
}
