/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/**
 * 
 */
package it.laitspa.cpf.faces.sogei.invoice;

import it.gov.fatturapa.sdi.fatturapa.v1.FatturaElettronicaType;
import it.laitspa.cpf.faces.UploadBeanModel;
import it.laitspa.cpf.faces.streaming.StreamingBean;
import it.laitspa.cpf.faces.utils.DataPage;
import it.laitspa.cpf.faces.utils.ExtendableDataModel;
import it.laitspa.cpf.faces.utils.FacesUtils;
import it.laitspa.cpf.model.QueryResult;
import it.laitspa.cpf.model.sogei.evento.EventoSogei;
import it.laitspa.cpf.model.sogei.inviofilesdi.AllegatoInvioFileSdiSogei;
import it.laitspa.cpf.model.sogei.inviofilesdi.InvioFileSdiSogei;
import it.laitspa.cpf.model.sogei.inviofilesdi.TipoAllegatoInvioFileSdiSogei;
import it.laitspa.cpf.model.sogei.notifica.NotificaSogei;
import it.laitspa.cpf.model.sogei.soggetto.SoggettoSogei;
import it.laitspa.cpf.spring.sogei.SogeiFacade;
import it.laitspa.cpf.util.log.LogUtils;
import it.laitspa.cpf.util.misc.FormUtils;
import it.laitspa.xsd.resolver.XmlMarshaller;

import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.faces.event.ActionEvent;

/**
 * @author andrea
 * 
 */
public class FluxBean
  extends UploadBeanModel
{

  public class FluxDataModel
    extends ExtendableDataModel<Object[]>
  {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    public FluxDataModel(int pageSize)
    {
      super(pageSize);
    }

    @SuppressWarnings("unchecked")
    @Override
    public DataPage<Object[]> fetchPage(int startRow, int pageSize)
    {

      // ISogei
      //
      SogeiFacade sdao = (SogeiFacade)FacesUtils.findBean("SogeiFacade");


      String partitaIvaCedente = FormUtils.makeQueryParameter(getPartitaIvaCedente());
      String partitaIvaCommittente = FormUtils.makeQueryParameter(getPartitaIvaCommittente());
      String codiceIpa = FormUtils.makeQueryParameter(getCodiceIpa());

      QueryResult qr =
          sdao.listFluxByCodiceEmittente(SoggettoSogei.SOGGETTO_UNICO, dataCaricamentoDa, dataCaricamentoA,
              partitaIvaCedente, partitaIvaCommittente, codiceIpa, startRow, pageSize);

      return new DataPage<Object[]>(qr.getCount(), startRow, qr.getItems());
    }

    @Override
    public Object getObjectPk(Object row)
    {
      return row.hashCode();
    }

  }

  /**
   * 
   */
  private static final long             serialVersionUID = 1L;
  private Date                          dataCaricamentoDa;
  private Date                          dataCaricamentoA;
  private String                        partitaIvaCedente;
  private String                        partitaIvaCommittente;
  private String                        codiceIpa;

  private String                        nomeFile;
  private String                        formato;
  private Integer                       codiceFlusso;

  private ExtendableDataModel<Object[]> listaCaricamenti;

  private List<NotificaSogei>           notifiche;
  private List<EventoSogei>             eventi;
  private InvioFileSdiSogei             invio;

  public ExtendableDataModel<Object[]> getListaCaricamenti()
  {
    if(listaCaricamenti == null)
      listaCaricamenti = new FluxDataModel(20);
    return listaCaricamenti;
  }

  public void setListaCaricamenti(ExtendableDataModel<Object[]> listaCaricamenti)
  {
    this.listaCaricamenti = listaCaricamenti;
  }

  public String getCodiceIpa()
  {
    return codiceIpa;
  }

  public void setCodiceIpa(String codiceIpa)
  {
    this.codiceIpa = codiceIpa;
  }

  public Date getDataCaricamentoDa()
  {
    return dataCaricamentoDa;
  }

  public void setDataCaricamentoDa(Date dataCaricamentoDa)
  {
    this.dataCaricamentoDa = dataCaricamentoDa;
  }

  public Date getDataCaricamentoA()
  {
    return dataCaricamentoA;
  }

  public void setDataCaricamentoA(Date dataCaricamentoA)
  {
    this.dataCaricamentoA = dataCaricamentoA;
  }

  public String getPartitaIvaCedente()
  {
    return partitaIvaCedente;
  }

  public void setPartitaIvaCedente(String partitaIvaCedente)
  {
    this.partitaIvaCedente = partitaIvaCedente;
  }

  public String getPartitaIvaCommittente()
  {
    return partitaIvaCommittente;
  }

  public void setPartitaIvaCommittente(String partitaIvaCommittente)
  {
    this.partitaIvaCommittente = partitaIvaCommittente;
  }

  public String doSearch()
  {
    listaCaricamenti = null;
    return "success";
  }

  public String doEditFlux()
  {

    Object id = FacesUtils.getRequestParameter("codice");
    Integer codiceFlusso = FormUtils.makeIntegerQueryParameter((String)id);
    if(codiceFlusso == null)
      return null;

    // Retrieve InvBean
    //
    InvBean b = FacesUtils.getFacesBean(InvBean.class);
    b.setCodiceFlusso(codiceFlusso);

    // ISogei sogei
    //
    SogeiFacade sdao = (SogeiFacade)FacesUtils.findBean("SogeiFacade");
    AllegatoInvioFileSdiSogei allegato =
        sdao.retrieveAllegato(codiceFlusso, TipoAllegatoInvioFileSdiSogei.LOTTO_NON_FIRMATO);

    if(allegato == null)
    {
      FacesUtils.addContextErrorMessage(getClass(), "error_fluxattachment_notfound");
      return null;
    }

    // Create object
    //
    XmlMarshaller<FatturaElettronicaType> mr = new XmlMarshaller<FatturaElettronicaType>();
    ByteArrayInputStream bis = new ByteArrayInputStream(allegato.getDatafile());
    FatturaElettronicaType invio = null;
    try
    {
      invio = mr.unmarshal(FatturaElettronicaType.class, bis, null);
      bis.close();
    }
    catch(Exception e)
    {
      LogUtils.error(getClass(), "Exception caught while unmarshalling allegato for flux "
          + codiceFlusso, e);
    }

    if(invio != null)
      b.setInvio(invio);

    return "editlottosdi";
  }

  public void doDownloadAttesaFlux(ActionEvent e)
  {

    Object id = FacesUtils.getRequestParameter("codice");
    Integer codiceFlusso = FormUtils.makeIntegerQueryParameter((String)id);
    if(codiceFlusso == null)
      return;

    // ISogei sogei
    //
    SogeiFacade sdao = (SogeiFacade)FacesUtils.findBean("SogeiFacade");
    AllegatoInvioFileSdiSogei allegato =
        sdao.retrieveAllegato(codiceFlusso, TipoAllegatoInvioFileSdiSogei.LOTTO_NON_FIRMATO);

    if(allegato == null)
    {
      FacesUtils.addContextErrorMessage(getClass(), "error_fluxattachment_notfound");
      return;
    }

    // Streaming bean.
    //
    StreamingBean sb = (StreamingBean)FacesUtils.getFacesBean("StreamingBean");
    sb.setFileName(allegato.getNomeFile());
    sb.setInline(false);
    sb.setData(allegato.getDatafile());
    sb.doCallStreamingServlet();
  }

  public void doDownloadFlux(ActionEvent e)
  {

    Object id = FacesUtils.getRequestParameter("codice");
    Integer codiceFlusso = FormUtils.makeIntegerQueryParameter((String)id);
    if(codiceFlusso == null)
      return;

    // ISogei sogei
    //
    SogeiFacade sdao = (SogeiFacade)FacesUtils.findBean("SogeiFacade");
    AllegatoInvioFileSdiSogei allegato =
        sdao.retrieveAllegato(codiceFlusso, TipoAllegatoInvioFileSdiSogei.LOTTO_FIRMATO);

    if(allegato == null)
    {
      FacesUtils.addContextErrorMessage(getClass(), "error_fluxattachment_notfound");
      return;
    }

    // Streaming bean.
    //
    StreamingBean sb = (StreamingBean)FacesUtils.getFacesBean("StreamingBean");
    sb.setFileName(allegato.getNomeFile());
    sb.setInline(false);
    sb.setData(allegato.getDatafile());
    sb.doCallStreamingServlet();
  }

  public Integer getCodiceFlusso()
  {
    return codiceFlusso;
  }

  public void setCodiceFlusso(Integer codiceFlusso)
  {
    this.codiceFlusso = codiceFlusso;
  }

  public String getNomeFile()
  {
    return nomeFile;
  }

  public void setNomeFile(String nomeFile)
  {
    this.nomeFile = nomeFile;
  }

  public String getFormato()
  {
    return formato;
  }

  public void setFormato(String formato)
  {
    this.formato = formato;
  }

  public void doPreparForFile(ActionEvent e)
  {
    throw new UnsupportedOperationException("Operazione non implementata.");
  }

  public void doProcessFile(ActionEvent e)
  {
    throw new UnsupportedOperationException("Operazione non implementata.");
  }
  
  public void doConfirmFlux(ActionEvent e)
  {

    Object id = FacesUtils.getRequestParameter("codice");
    Integer codiceFlusso = FormUtils.makeIntegerQueryParameter((String)id);
    if(codiceFlusso == null)
      return;

    // ISogei sogei
    //
    SogeiFacade sdao = (SogeiFacade)FacesUtils.findBean("SogeiFacade");
    if (sdao.serializeSignedAllegatoForFlux(codiceFlusso, null, null, null))
    {
      FacesUtils.addContextMessage(getClass(), "message_confirmdone_title", "message_confirmdone_text");
      this.listaCaricamenti = null;
    }
    else
      FacesUtils.addContextErrorMessage(getClass(), "error_confirmflux_text");
  }

  public List<NotificaSogei> getNotifiche()
  {
    return notifiche;
  }

  public void setNotifiche(List<NotificaSogei> notifiche)
  {
    this.notifiche = notifiche;
  }

  public void doN(ActionEvent e)
  {
    throw new UnsupportedOperationException("Operazione non implementata.");
  }

  public List<EventoSogei> getEventi()
  {
    return eventi;
  }

  public void setEventi(List<EventoSogei> eventi)
  {
    this.eventi = eventi;
  }

  public InvioFileSdiSogei getInvio()
  {
    return invio;
  }

  public void setInvio(InvioFileSdiSogei invio)
  {
    this.invio = invio;
  }

  public void doEv(ActionEvent e)
  {
    Integer codice =
        FormUtils.makeIntegerQueryParameter((String)FacesUtils.getRequestParameter("id"));

    SogeiFacade sf = (SogeiFacade) FacesUtils.findBean("SogeiFacade");

    this.eventi = sf.listEv(codice);
    this.invio = null;
    
    // Find inside model.
    //
    if (listaCaricamenti != null)
    {
      List<Object[]> oggetti = listaCaricamenti.getListItems();
      Iterator<Object[]> i_oggetti = oggetti.iterator();
      while (i_oggetti.hasNext() && invio == null)
      {
        Object[] obj = i_oggetti.next();
        InvioFileSdiSogei c_invio = (InvioFileSdiSogei) obj[0];
        if (c_invio.getCodice().equals(codice))
          invio = c_invio;
      }
    }
  }
  
  
}
