/*
* Copyright 2014 - LAit SpA
*				 Realizzato da Icona Management srl su commessa LAit SpA
* Copyright 2015- LAit SpA
*                                                  Aggiornato da LAit SpA
*
* Concesso in licenza a norma dell'EUPL, versione 1.1 o
* successive dell'EUPL (la "Licenza")– non appena saranno
* approvate dalla Commissione europea;
* Non è possibile utilizzare l'opera salvo nel rispetto della Licenza.
* È possibile ottenere una copia della Licenza al seguente indirizzo:
*
* http://ec.europa.eu/idabc/eupl
*
* Salvo diversamente indicato dalla legge applicabile o
* concordato per iscritto, il software distribuito secondo
* i termini della Licenza è distribuito "TAL QUALE",
* SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO,
* esplicite o implicite.
* Si veda la Licenza per la lingua specifica che disciplina
* le autorizzazioni e le limitazioni secondo i termini della
* Licenza.
*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package it.laitspa.cpf.faces.sogei;

import it.laitspa.cpf.faces.BeanModel;
import it.laitspa.cpf.faces.utils.FacesUtils;
import it.laitspa.cpf.util.misc.JndiServiceLocator;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONObject;

/**
 * 
 * @author andrea
 */
public class MenuBean
  extends BeanModel
{

  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  private String            selectedChild;
  private Boolean[]         expandedNodes;
  private List<String[]>    news;

  private static Date       lastUpdate;
  private static String     version          = "1.0";

  public String getSelectedChild()
  {
    return selectedChild;
  }

  public void setSelectedChild(String selectedChild)
  {
    this.selectedChild = selectedChild;
  }

  /** Creates a new instance of MenuBean **/
  public MenuBean()
  {
    expandedNodes = new Boolean[16];
    // for (int i = 0; i < 15; i++)
    // expandedNodes[i] = Boolean.FALSE;

    expandedNodes[0] = Boolean.TRUE;

  }

  public Boolean[] getExpandedNodes()
  {
    return expandedNodes;
  }

  public void setExpandedNodes(Boolean[] expandedNodes)
  {
    this.expandedNodes = expandedNodes;
  }

  public String updateCurrent()
  {
    String outcome = (String)FacesUtils.getRequestParameter("current_outcome");
    return outcome;
  }

  public String getStyleSheet()
  {
    JndiServiceLocator jl = JndiServiceLocator.getInstance();
    String css = null;
    try
    {
      css = (String)jl.lookup("customCSS");
    }
    catch(Exception e)
    {
      css = null;
    }
    return css;
  }

  public List<String[]> getNews()
  {
    /*
    Date now = new Date();
    GregorianCalendar gc = new GregorianCalendar();
    gc.setTime(now);
    gc.add(Calendar.HOUR, -1);
    Date datecheck = gc.getTime();

    if(lastUpdate == null || lastUpdate.before(datecheck))
    {
      lastUpdate = now;

      HttpURLConnection connection = null;
      try
      {
        URL url = new URL("http://pserv.cloudapp.net/pserv/rest/pserv/property/SDIDPA/" + version);
        connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("GET");

        if(connection.getResponseCode() == HttpURLConnection.HTTP_OK)
        {
          BufferedReader br =
              new BufferedReader(new InputStreamReader((connection.getInputStream())));
          String buffer = null;
          String json = "";
          while((buffer = br.readLine()) != null)
          {
            json += buffer;
          }

          JSONObject obj = new JSONObject(json);
          if(obj != null)
          {
            news = new ArrayList<String[]>();
            JSONArray arr = obj.getJSONArray("properties");
            for(int i = 0; i < arr.length(); i++)
            {
              String descrizione = arr.getJSONObject(i).getString("description");
              String textualValue = arr.getJSONObject(i).getString("textualValue");
              news.add(new String[] { descrizione, textualValue });
            }
          }

        }
      }
      catch(Exception e)
      {
        // Nothing.
        //
      }
      finally
      {
        if(connection != null)
          connection.disconnect();
      }

    }

    return news;
    */

    return new ArrayList<String[]>();
  }

}
